//
//  RVSSecurityService.h
//  AriverSecurity
//
//  Created by lyusheng on 2020/7/23.
//  Copyright © 2020 Alipay. All rights reserved.
//

#ifndef RVSSecurityService_h
#define RVSSecurityService_h

#import <AriverApp/RVAContext.h>

@protocol RVSSecurityService <NSObject>
@optional
/// SSL管控
- (BOOL)isForceSSLWithAppId:(NSString *)appId;
/// 授权项
//- (BOOL)useLocalAuthorizeConfig:(NSString *)jsApiName;
//- (BOOL)needAuthorizeWithJsApi:(NSString *)jsApiName;
// cookie隔离
- (BOOL)isNeedSafeCookie:(NSString *)appId;
@end

NS_INLINE id<RVSSecurityService> RVSSecurityServiceGet(){
    id<RVSSecurityService> service = [RVAContextGet() findServiceByName:@"RVSSecurityService" defaultCls:NSClassFromString(@"RVSSecurityServiceImp")];
    return service;
}

#endif /* RVSSecurityService_h */
