//
//  RVRErrorCode.h
//  AriverResource
//
//  Created by nico on 2019/4/12.
//
// 错误域
extern NSString *const NXR_ERROR_DOMAIN;
extern NSString *const NXR_ERROR_OPTIONS;

/**
 NXRErrorUnknown =           10000,
 NXRErrorCanNotOpenApp =     10001,
 NXRErrorUnzipFailed =       10003,
 NXRErrorRPCException =      10004,
 NXRErrorRPCCalling =        10005,
 NXRErrorRPCNoExpired =      10006,
 NXRErrorVerifyFailed =      10007,
 NXRErrorPatchFailed =       10008,
 NXRErrorAppCacheNotExist =  10009,
 NXRErrorDownloadFailed =    10010
 */
typedef NS_ENUM(NSUInteger, NXRErrorCode) {
    
    NXRErrorUnknown = 10000,    //  未知错误
    NXRErrorCanNotOpenApp,      //  10001 无法打开包, appId异常
    NXRErrorUnzipFailed,        //  10002 解压包失败
    NXRErrorRPCException,       //  10003 rpc异常, 无应用
    NXRErrorRPCCalling,         //  10004 上一个请求尚未结束
    NXRErrorRPCNoExpired,       //  10005 请求的app未过期
    NXRErrorVerifyFailed,       //  10006 验签失败
    NXRErrorPatchFailed,        //  10007 增量更新失败
    NXRErrorAppCacheNotExist,   //  10008 应用本地缓存不存在 (e.g. 请求失败,本地无应用缓存)
    NXRErrorDownloadFailed,     //  10009 下载失败
    NXRErrorPrepareTimeOut,     //  10010 准备超时
    NXRErrorOpenAppBreak,       //  10011 启动应用打断
    NXRErrorSDKVersionError     //  10012 支持最低AppxSDK版本过低
};

