//
//  NARequestManager.h
//  NebulamPaaSBiz
//
//  Created by yangwei on 17/4/28.
//  Copyright © 2017年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

@class UnionResourceInfo;
@class UnionResourceMiniPluginInfoPB;
@class ValidPluginInfoPbPB;

@interface MPNARequestManager : NSObject<NAMRequestProtocol>

+ (MPNARequestManager *)sharedInctance;

/// 处理小程序（含宿主小程序）
- (void)handleNebulaWithInfo:(UnionResourceInfo *)info error:(NSError **)error;

/// 处理插件
- (void)handlePluginWithInfo:(UnionResourceMiniPluginInfoPB *)info error:(NSError **)error;

/// 处理插件权限
- (void)handleValidPlugin:(NSArray<ValidPluginInfoPbPB*>*)info error:(NSError **)error;

- (void)validPlugins:(NSArray *)pluginIdsArray
              params:(NSDictionary *)params
              finish:(void (^)(id data, NSError *error))finish;

// 是否强制替换cube的包地址
@property (nonatomic) BOOL forceCube;

@end
