//
//  TAInterceptRequestManager.h
//  TinyappService
//
//  Created by 闻蹊 on 2018/11/22.
//  Copyright © 2018 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef void(^TAInterceptResultCallback)(NSDictionary * _Nullable result, NSError * _Nullable error);


NS_ASSUME_NONNULL_BEGIN

@interface TAInterceptRequestManager : NSObject

+ (TAInterceptRequestManager *)sharedInstance;

- (void)requestLimitControlDataWithParams:(NSDictionary *)params
                                 callback:(TAInterceptResultCallback)callback;

- (void)requestLimitControlDataWithParams:(NSDictionary *)params
                                 callback:(TAInterceptResultCallback)callback
                                  timeout:(NSTimeInterval)timeout;

- (void)requestProxyDataWithParams:(NSDictionary *)params
                          callback:(TAInterceptResultCallback)callback;

- (void)requestProxyDataWithParams:(NSDictionary *)params
                          callback:(TAInterceptResultCallback)callback
                           timeout:(NSTimeInterval)timeout;

@end

NS_ASSUME_NONNULL_END
