//
//  NBSUtils.h
//  NebulaSecurity
//
//  Created by runfeng.crf on 2019/1/23.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NSString * NBSString(id string);
NSNumber * NBSNumber(id number);
NSArray * NBSArray(id array);
NSDictionary * NBSDictionary(id dic);
NSString * NBSJsonStr(NSDictionary * dic);
NSDictionary * NBSJsonDic(NSString * jsonStr);
NSDictionary * NBSJsonDicWithData(NSData *data);

void NBSLogInfo(NSString* format,...);

@interface NBSUtils : NSObject

+ (NSDictionary *)mapStringString:(NSDictionary *)params;
+ (BOOL)isInnerTinyApp:(NSString *)appId;
+ (BOOL)isTinyAppWithSession:(PSDSession *)session;


@end

#ifdef ENABLE_DEPENDENCY_MOCK

@interface TAWebViewUtils : NSObject

+ (BOOL)isEmbeddedWebViewWith:(PSDSession*)session;

+ (BOOL)isEmbeddedMiniWebViewWith:(PSDSession*)session;

+ (NSString*)parentAppIdWith:(PSDSession*)session;

+ (BOOL)canEmbedWebViewOpenOfflinePackge:(NSString *)packageAppid
                               tinyAppId:(NSString *)tinyAppid;

@end

@interface H5WebViewController (NebulaSecurity)

- (BOOL)isSubViewMode;

@end

#endif
