//
//  H5HTTPRequestManager.h
//  NebulaBiz
//
//  Created by runfeng.crf on 2018/12/18.
//  Copyright © 2018 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

extern NSString * const H5HTTPConfigBizKey;

typedef void (^H5HTTPCompletionBlock)(NSHTTPURLResponse *response, NSData *data, NSError *error);
typedef void (^H5HTTTPHeadReceiveBlock)(NSDictionary *headers, NSError *error);

@interface H5HTTPRequestManager : NSObject

+ (instancetype)manager;

- (NSString *)sendRequest:(NSURLRequest *)request completion:(H5HTTPCompletionBlock)completion;
- (NSString *)sendRequest:(NSURLRequest *)request config:(NSDictionary *)config completion:(H5HTTPCompletionBlock)completion headerReceive:(H5HTTTPHeadReceiveBlock)headRecieve;
- (void)cancelRequest:(NSString *)requestId;

@end
