//
//  NBWhiteScreenMonitor.h
//  NebulaLogging
//
//  Created by 章海滨 on 2019/8/6.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSUInteger, NBLogEmptyCheckResult) {
    NBLogEmptyCheckResultUnkown = 0,
    NBLogEmptyCheckResultBlank,
    NBLogEmptyCheckResultNotBlank
};

typedef void (^NBAppxRenderBlankBlock)(NSDictionary *result);

@interface NBWhiteScreenMonitor : NSObject

+ (NBLogEmptyCheckResult)checkBlankScreen:(RVKScene *)page sampleCount:(NSUInteger)sampleCount;
+ (void)checkAppxRenderBlank:(RVKScene *)scene callback:(NBAppxRenderBlankBlock)callback;

@end

NS_ASSUME_NONNULL_END
