//
//  NBLogSPMHelper.h
//  NebulaBiz
//
//  Created by Glance on 16/8/10.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

static const char *kNBSPMInfo_KEY = "kNBSPMInfo_KEY";
static const char *kNBSPMInfo_KEY_APPX = "kNBSPMInfo_KEY_APPX";
static NSString *kNBSPM_APPX_STARTKEY = @"appx_scm_data";


@interface H5SPMToken : NSObject<NSCopying>

@property (nonatomic, copy) NSString *uuid;
@property (nonatomic, weak) UIView * psdContentView;//每个页面的contentView不会变，关联同一页面不同类型埋点数据
@property (nonatomic, assign) SPMPageType pageType;
@end


@interface NBSPMInfo : NSObject

@property(nonatomic, strong) NSString *spmId;
@property(nonatomic, strong) H5SPMToken *spmToken;
@property(nonatomic, strong) NSString *bizType;
@property(nonatomic, strong) NSString *chInfo;
@property(nonatomic, strong) NSDictionary *spmDetail;
@property(nonatomic, assign) BOOL isFromAppX;
@property(nonatomic, strong) NSDictionary *uep;
@property(nonatomic, assign) BOOL uepIsTiny;

@end


@interface NBSPMHelper : NSObject


NBSPMInfo *getSPMInfo(RVKContentView * view);
NBSPMInfo *getUEPSPMInfo(RVKContentView * view); // 用于uep埋点的串联

+ (NBSPMInfo *)prepareSPM:(RVKContentView *)view;

+ (NSDictionary *)getTracerInfoFromScene:(RVKScene *)scene;

+ (H5SPMToken *)tokenOfPSDContentView:(RVKContentView *)view;

+ (void)logPageStartWithSpmId:(NSString *)spmId index:(NSObject *)index inPage:(RVKPage *)page;

+ (void)logPageEndWithSpmId:(NSString *)spmId index:(NSObject *)index bizType:(NSString *)bizType param:(NSDictionary *)param;

+ (void)updateLastSpm:(NSString *)spmId index:(NSObject *)index;

+ (SPMPageType)pageTypeFromContext:(RVKContext *)context;

@end

