//
//  NBOSLog.h
//  NebulaLogging
//
//  Created by 张光宇 on 2019/6/25.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

#include <os/signpost.h>
#if DEBUG
#define OS_LOG 1
#endif

#if OS_LOG
#define _os_log nb_os_logger()
#define ap_os_log_create os_log_create
#define ap_os_signpost_id_make_with_pointer os_signpost_id_make_with_pointer

#define ap_os_log(format, ...)  \
ap_SuppressUnguardedAvailabilityWarning({\
os_log(_os_log, format, ##__VA_ARGS__);\
})

#define ap_os_signpost_interval_begin(interval_id, name, ...)  \
ap_SuppressUnguardedAvailabilityWarning({\
os_signpost_interval_begin(_os_log, interval_id, name, ##__VA_ARGS__);\
})

#define ap_os_signpost_interval_end(interval_id, name, ...)  \
ap_SuppressUnguardedAvailabilityWarning({\
os_signpost_interval_end(_os_log, interval_id, name, ##__VA_ARGS__);\
})

#define ap_os_signpost_id_generate(interval_id_ref) \
ap_SuppressUnguardedAvailabilityWarning({ \
*interval_id_ref=os_signpost_id_generate(_os_log);  \
})

#else

#define ap_os_log_create
#define ap_os_signpost_id_make_with_pointer
#define ap_os_signpost_interval_begin(log, interval_id, name, ...)
#define ap_os_signpost_interval_end(log, interval_id, name, ...)
#define ap_os_signpost_id_generate(interval_id_ref, log)

#endif


#define SUPPRESS_AVAILABILITY_BEGIN \
_Pragma("clang diagnostic push") \
_Pragma("clang diagnostic ignored \"-Wunsupported-availability-guard\"")\
_Pragma("clang diagnostic ignored \"-Wunguarded-availability-new\"")

#define SUPPRESS_AVAILABILITY_END \
_Pragma("clang diagnostic pop")

#define ap_SuppressUnguardedAvailabilityWarning( codeIfAvailable ) \
SUPPRESS_AVAILABILITY_BEGIN \
if (__builtin_available(iOS 12.0, *)) {\
SUPPRESS_AVAILABILITY_END \
if (@available(iOS 12.0, *)) { \
codeIfAvailable \
} \
} \
else { \
SUPPRESS_AVAILABILITY_END \
assert(0);\
}


os_log_t nb_os_logger();
