//
//  NBFullLinkStore.h
//  NebulaLogging
//
//  Created by 张光宇 on 2018/12/19.
//  Copyright © 2018 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>

extern NSString *const kFLStoreSceneExpandoKey;

NS_ASSUME_NONNULL_BEGIN
@class PSDScene;

@interface NBFullLinkStore : NSObject
@property(nonatomic,weak)UIViewController *currentViewController;


+ (instancetype)appStore:(NSString *)appId;

+ (NSString *)getAppIdFromSession:(RVKSession *)session;
/*
 * scene级别的埋点，请调用此接口
 * 实现逻辑：
 *   若是首页面，则直接调[NBFullLinkStore store:appId]
 *   否则，从[scene getExpando:kFLStoreSceneExpandoKey]获取
 */
+ (instancetype)appStore:(NSString *)appId scene:(RVKScene * _Nullable)scene;

+ (NBFullLinkStore *)getSceneStoreByEvent:(RVKEvent *) event;

+ (long) getUniqueId;

- (NSString *)getExtraAttrDict2String;
- (void)appendExtraAttrDict4Key:(NSString *)key value:(NSString *)value;
- (void)removeExtraAttrDict4Key:(NSString *)key;

- (NSString *)getUrlVarByUrlString:(NSString *)url;
- (void) cleanUrlVarByUrlString:(NSString *)url;

- (void)addTimeStub:(NSString *)phase withTime:(CFTimeInterval)mediaTime;

- (void)addTimeStub:(NSString *)phase;

- (void)addCostAttr:(NSString *)key value:(NSUInteger)costInMs;

- (void)addBizAttrWithUniqueId:(NSString *)key value:(NSString *)value;

- (void)addBizAttr:(NSString *)key value:(NSString *)value;
- (NSString *)getBizAttr:(NSString *)key;

- (long)getTimeStub:(NSString *)phase;

- (void)addAttributesFromDictionary:(NSDictionary *)dictionary;

- (NSString *)appId;

- (NSString *)getAttributeInfoString;

- (NSDictionary *)gatherDataAndClearCache;
- (void) clearDataCache;

+ (void)clearStore:(NBFullLinkStore *)store;

@end

NS_ASSUME_NONNULL_END
