//
//  TabBarProtocol.h
//  NebulaApp
//
//  Created by lyusheng on 2018/8/13.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <AriverApp/RVATabBarProtocol.h>

@protocol TabBarProtocol <RVATabBarProtocol>

@property(nonatomic, weak) H5WebViewController *cachedParentViewController;

/**
 多tab模式时，返回兄弟tab里选中的的H5WebViewController
 非tab模式时，直接返回调用的H5WebViewController
 */
@property(nonatomic, readonly) H5WebViewController *selectedViewController;

/**
 持有创建的子Tab对应的H5WebViewController
 键值对中，键名为对应Tab的identifier
 */
@property(nonatomic, strong) NSDictionary<NSString *, H5WebViewController *> *cachedChildViewControllers;
@end
