//
//  TANavBarUtil.h
//  TinyappService
//
//  Created by niki on 2018/10/25.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN


@class PSDContext;

typedef enum {
    TANaviBarTypeNone,
    TANaviBarTypeHome,
    TANaviBarTypeBack
} TANaviBarType;


@interface TANavBarUtil : NSObject

// 重置导航栏底部分割线的颜色
+ (void)resetNavigationBarBottomLineColor;

// 小程序右上角三个点是否使用新样式，默认使用新样式
+ (BOOL)enabeNaviBarNewPopMenu:(NSString *)appId;

// 小程序右上角是否展示收藏icon
+ (BOOL)enableNaviBarShowFavorite:(NSString *)appId;

// iOS13忽略用户dark模式，即iOS13下UIStatusBarStyleDefault改成UIStatusBarStyleDarkContent
+ (void)setStatusBarStyle:(UIStatusBarStyle)style animated:(BOOL)animation;

+ (BOOL)allowCallApiWithContext:(PSDContext *)context;

@end

NS_ASSUME_NONNULL_END
