
//
//  H5WKWebView.h
//  NebulaBiz
//
//  Created by theone on 16/12/1.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import <WebKit/WebKit.h>
#import <AriverNebula/H5WebViewInterface.h>

@protocol H5WebViewObserveProtocol <NSObject>
- (void)h5webViewObserveValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary *)change context:(void *)context;
@end

@interface H5WKWebView : WKWebView<H5WebViewInterface>
@property(nonatomic, weak) id<H5WebViewObserveProtocol> h5webViwObserveProtocol;
@property(nonatomic, strong) NSString *nextHrefChangeType;
- (void)addObserveWithKeyPath:(NSString *)keyPath options:(NSKeyValueObservingOptions)options context:(void *)context;
+ (H5WKWebView *_Nullable)fetchPrepareContentViewWithFrame:(CGRect)frame configuration:(NSDictionary *)configuration;
+ (void)prepareContentView;
+ (NSData *)getDataWithKey:(NSString *)key;
+ (void)removeDataWithKey:(NSString *)key;

- (void)setDelegate:(id)delegate;
@end
