//
//  NXIAppCreateHelper.h
//  NebulaIntegration
//
//  Created by nico on 15/08/2018.
//  Copyright © 2018 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AriverApp/RVASession.h>
#import "H5Service.h"
#import "H5WebViewController.h"
#import "H5Service.h"
#import "H5WebViewInterface.h"

@interface NXIAppCreateHelper : NSObject
+ (RVASession *)createH5Session:(NSDictionary *)params
                         JSApis:(NSDictionary *)JSApis
                   withDelegate:(id<H5ServiceDelegate>)delegate
                       listener:(id<PSDPluginProtocol>)listener
                         h5Mode:(H5Mode)h5Mode;

+ (H5WebViewController *)createWebViewController:(NSDictionary *)params
                                          JSApis:(NSDictionary *)JSApis
                                    withDelegate:(id<H5ServiceDelegate>)delegate;

+ (UIView<H5WebViewInterface> * _Nonnull)createWebViewWithVC:(UIViewController * _Nullable)currentVC
                                                      params:(NSDictionary * _Nullable)params
                                                      JSApis:(NSDictionary * _Nullable)JSApis
                                                     bizCode:(NSString * _Nonnull)bizCode;
@end
