//
//  RVMapViewProtocol.h
//  APMap
//
//  Created by 百喻 on 2019/5/28.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "RVMapViewHeader.h"


NS_ASSUME_NONNULL_BEGIN

typedef void(^RVMapViewCommonBlock)(NSDictionary* data);
typedef void(^RVMapViewImageBlock)(UIImage *image, NSData *imageData);

typedef NS_ENUM(NSInteger,RVMapRouteSearchType) {
    RVMapRouteSearchTypeUnknow = 0,
    RVMapRouteSearchTypeWalk,
    RVMapRouteSearchTypeRide,
    RVMapRouteSearchTypeDrive,
    RVMapRouteSearchTypeBus
};

typedef NS_ENUM(NSInteger,RVMapType) {
    RVMapTypeStandard = 0,  ///< 普通地图
    RVMapTypeSatellite,     ///< 卫星地图
    RVMapTypeStandardNight, ///< 夜间视图(高德)
    RVMapTypeNavi,          ///< 导航视图(高德)
    RVMapTypeBus,           ///< 公交视图(高德)
    RVMapTypeTerrain,       ///< 地形图 (google)
    RVMapTypeHybrid,        ///< (google)
    RVMapTypeNone           ///< (google)
};

@protocol RVMapViewProtocol;

#pragma mark - RVMapViewDelegate
@protocol RVMapViewDelegate <NSObject>
@optional
- (void)rvMapInitComplete:(UIView<RVMapViewProtocol> *)mapView;
- (void)rvMapViewDidFailLoadingMap:(UIView<RVMapViewProtocol> *)mapView withError:(NSError *)error;
@end

@protocol RVMapViewDataSource <NSObject>
- (void)rvMapResourceOfUrl:(NSString *)url completion:(RVMapViewCommonBlock)completion;
- (void)rvMapImageResourceOfUrl:(NSString *)url size:(CGSize)size completion:(RVMapViewImageBlock)completion;
@end

#pragma mark - RVMapViewProtocol -
@protocol RVMapViewProtocol <NSObject>

@required
@property (nonatomic,weak) id<RVMapViewDataSource> dataSource;
@property (nonatomic,weak) id<RVMapViewDelegate> delegate;
// 需要各个引擎实现的细粒度接口
@property (nonatomic) CGFloat zoomLevel;
@property (nonatomic) CGFloat minZoomLevel;
@property (nonatomic) CGFloat maxZoomLevel;
@property (nonatomic) RVMapType mapType;
@property (nonatomic) BOOL touchPOIEnabled;
@property (nonatomic) CLLocationCoordinate2D centerCoordinate;
@property (nonatomic) BOOL showsUserLocation;
@property (nonatomic) UIEdgeInsets includePadding;
@property (nonatomic) BOOL includePointsAnimation;
@property (nonatomic) BOOL allowsAnnotationViewSorting;
@property (nonatomic) CGFloat cameraDegree;
@property (nonatomic) CGFloat rotationDegree;
@property (nonatomic, readonly) NSString *sdkVersion;
@property (nonatomic, readonly) NSString *sdkName;
@property (nonatomic, readonly) BOOL isSupportOversea;
@property (nonatomic, readonly) BOOL isSupport3D;
@property (nonatomic, assign) BOOL zoomEnabled;
@property (nonatomic, assign) BOOL scrollEnabled;
@property (nonatomic, assign) BOOL rotateEnabled;
@property (nonatomic, assign) CGPoint screenAnchor;

@property (nonatomic, copy) RVMapViewCommonBlock tappedBlock;
@property (nonatomic, copy) RVMapViewCommonBlock controlTappedBlock;
@property (nonatomic, copy) RVMapViewCommonBlock markerTappedBlock;
@property (nonatomic, copy) RVMapViewCommonBlock calloutTappedBlock;
@property (nonatomic, copy) RVMapViewCommonBlock regionChangedBlock;
@property (nonatomic, copy) RVMapViewCommonBlock translateMarkerEndBlock;
@property (nonatomic, copy) RVMapViewCommonBlock poiTappedBlock;

- (void)addAnnotation:(id<RVMapAnnotationProtocol>)annotation;
- (void)addAnnotations:(NSArray *)annotations;
- (id<RVMapAnnotationProtocol>)convertAnnotation:(id<RVMapAnnotationProtocol>)annotation;
- (NSArray *)annotations;
- (NSArray *)overlays;
- (void)addOverlay:(id)overlay level:(RVMapOverlayLevel)level;
- (void)addOverlays:(NSArray *)overlays level:(RVMapOverlayLevel)level;
- (void)addTileOverLay:(RVMapTileOverLay *)overlay;
- (void)addGroundOverLay:(RVMapGroundOverlay *)overlay;

- (UIView<RVMapAnnotationViewProtocol> *)viewForAnnotation:(id<RVMapAnnotationProtocol>)annotation;

- (void)removeRVMapAnnotations;
- (void)removeAnnotation:(id<RVMapAnnotationProtocol>)annotation;
- (void)removeAnnotations:(NSArray<RVMapAnnotationProtocol> *)annotations;
- (void)removeOverlay:(id)overlay;
- (void)removeOverlays:(NSArray *)overlays;
- (void)removeTileOverlays;
- (void)removeGroundOverlays;
- (void)removeRouteAnntations;

- (void)showAnnotation:(id<RVMapAnnotationProtocol>)annotation;
- (void)showAnnotations:(NSArray *)annotations;
- (void)hiddenAnnotation:(id<RVMapAnnotationProtocol>)annotation;
- (void)hiddenAnnotations:(NSArray *)annotations;
- (void)updateUserLocationAnnotationWithAnnotation:(id<RVMapAnnotationProtocol>)annotation;

- (void)addCircles:(NSArray<RVMapCircleProtocol> *)circles;
- (void)addPolylines:(NSArray<RVMapPolylineProtocol> *)polylines;
- (void)setPolylines:(NSArray<RVMapPolylineProtocol> *)polylines;
- (void)setPolygons:(NSArray<RVMapPolygonProtocol> *)polygons;
- (void)setControls:(NSArray<RVMapControl *> *)controls;

- (void)setIncludePoints:(NSArray<NSDictionary *> *)includePoints;
- (void)setIncludePoints:(NSArray<NSDictionary *> *)includePoints config:(NSDictionary *)config;
- (void)setCameraDegree:(CGFloat)degree animated:(BOOL)animated duration:(CFTimeInterval)duration;

- (CLLocationCoordinate2D)getCenterLocation;
- (NSDictionary *)getVisibleRegion;
- (CGPoint)convertCoordinate:(CLLocationCoordinate2D)coordinate toPointToView:(UIView *)view;
- (CLLocationCoordinate2D)convertPoint:(CGPoint)point toCoordinateFromView:(UIView *)view;
- (void)moveToLocation;
- (void)moveToLocation:(CLLocationCoordinate2D)coordinate;
- (void)gestureEnable:(BOOL)yesOrNo;
- (void)showSatelliteMap:(BOOL)yesOrNo;
- (void)showsScale:(BOOL)yesOrNo;
- (void)showsCompass:(BOOL)yesOrNo;
- (void)showsTraffic:(BOOL)yesOrNo;
- (void)showsLabels:(BOOL)yesOrNo;
- (void)changeLogoPosition:(CGPoint)point;
- (void)rotateCameraEnabled:(BOOL)yesOrNo;
- (void)setLimitRegion:(NSArray *)limitRegion;

- (void)showAnimateWithMarkerData:(NSInteger)markerId;
- (void)routePlanWithRequest:(RVMapRoutePlanRequest *)request callBack:(RVMapViewCommonBlock)callBack;
- (void)clearRouteLine;

- (void)showTranslateMarker:(NSInteger)markerId markerData:(RVMapTranslateAnnotation *)markerData callback:(RVMapViewCommonBlock)callback;
- (void)showSmoothMoveMarkerAnimate:(RVMapMoveMarkerModel *)markerData callback:(RVMapViewCommonBlock)callback;
- (void)stopSmoothMoveMarkerAnimate:(NSString *)markerId callback:(RVMapViewCommonBlock)callback;
- (void)showSmoothMovePolylineAnimate:(id<RVMapPolylineProtocol>)polylineData callback:(RVMapViewCommonBlock)callback;
- (void)stopSmoothMovePolylineAnimate:(NSString *)polylineId callback:(RVMapViewCommonBlock)callback;
- (BOOL)setPolylineWithCoordinates:(CLLocationCoordinate2D *)coords count:(NSInteger)count;

- (void)setCustomMapStyleWithId:(NSString *)styleId;
- (void)setCustomMapStyleWithWebData:(NSData *)data;
- (void)setCustomWorldMapStyleWithPath:(NSString *)path;
- (void)setCustomTextureResourcePath:(NSString *)customTextureResourcePath;
 
// cluster marker
- (void)updateClusterTree;
- (void)updateClusterTreeWithDatas:(NSArray *)clusterDatas;
- (double)metersPerPointForZoomLevel:(CGFloat)zoomLevel;
- (void)updateClusterMarkers;
- (void)setupClusterSetting:(NSDictionary *)setting;
- (NSDictionary *)visibleMapRect;

// collosion marker
- (void)updateCollosionTree;
- (void)updateCollosionTreeWithDatas:(NSArray *)collosionDatas;
- (void)updateCollosionMarkers;
- (void)setupCollosionSetting:(NSDictionary *)setting;

// rangeDisplay Anno
- (void)addRangeDisplayAnno:(id<RVMapAnnotationProtocol>)anno;
- (void)removeRangeDisplayAnno:(id<RVMapAnnotationProtocol>)anno;
- (void)updateDisplayRangeMarkers;

- (id<RVMapAnnotationProtocol>)findCommonAnnotationWithId:(NSString *)annotationId;

// Zebra
- (void)handleDSLWithParams:(NSDictionary *)params layoutString:(NSString *)layoutString src:(NSString *)srcPath completion:(void (^)(RVZebraView * _Nullable view,BOOL isLoaded,NSInteger errorCode))completion;
- (void)handleDSLWithParams:(NSDictionary *)params layoutString:(NSString *)layoutString src:(NSString *)srcPath needCache:(BOOL)needCache completion:(void (^)(UIImage * _Nullable image,BOOL isLoaded,NSInteger errorCode))completion;
@end

NS_ASSUME_NONNULL_END


