//
//  RVMapUtils.h
//  APMap
//
//  Created by 百喻 on 2019/1/18.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface RVMapUtils : NSObject
+ (UIColor *)getColorWithColorStr:(NSString *)colorStr;
+ (NSString *)transforColorStrToArgbWithColorStr:(NSString *)colorStr;
+ (UIImage*)convertViewToImage:(UIView*)v;
+ (UIImage *)downsampleImageWithData:(NSData *)data size:(CGSize)size;
+ (NSString*)hashForImage:(UIImage *)image imageData:(NSData *)imageData;
+ (UIImage *)scaleImage:(UIImage*)sourceImage toSize:(CGSize)targetSize;
+ (UIImage *)rotateImage:(UIImage*)sourceImage byDegrees:(CGFloat)degrees;
+ (UIImage *)applyImage:(UIImage*)sourceImage byAlpha:(CGFloat)alpha;
+ (UIImage *)appendImage:(UIImage *)img withText:(NSString *)text withColor:(UIColor *)color;
+ (UIImage *)appendImage:(UIImage *)img text:(NSString *)text textAlignment:(NSTextAlignment)textAlignment fontType:(NSString *)fontType color:(UIColor *)color bgColor:(UIColor *)bgColor;
+ (NSString *)getCurrentDeviceModel;
+ (BOOL)inDisplayRange:(NSDictionary *)displayRange scale:(CGFloat)scale;
+ (BOOL)inDisplayRanges:(NSArray *)displayRanges scale:(CGFloat)scale;

// calculateDistance
+ (NSMutableArray *)getPointsOnline:(NSArray *)points distance:(CGFloat)distance;
+ (CGFloat)calculateDistance:(NSArray *)points;
+ (NSDictionary *)calculateDistanceWithData:(NSDictionary *)data;
+ (CLLocationCoordinate2D)getCoordinateWithDictionary:(NSDictionary *)dictionary;
// wkt格式支持
+ (NSMutableArray *)getPointsWithWKTString:(NSString *)wktString;
@end

@interface NSDictionary(RVMap)
- (NSInteger)integerForKey_map:(NSString *)key;
- (NSString *)stringForKey_map:(NSString *)key;
- (NSDictionary *)dictionaryForKey_map:(NSString *)key;
- (CGFloat)floatForKey_map:(NSString *)key;
- (BOOL)boolForKey_map:(NSString *)key;
- (NSArray *)arrayForKey_map:(NSString *)key;
@end

@interface UIColor(RVMap)
+ (UIColor *)colorWithRGB_map:(int)rgb;
+ (UIColor *)colorWithRGB_map:(int)rgb alpha:(CGFloat)alpha;
@end

@interface UIView(RVMap)
@property (nonatomic) CGFloat left_map;
@property (nonatomic) CGFloat top_map;
@property (nonatomic) CGFloat right_map;
@property (nonatomic) CGFloat bottom_map;
@property (nonatomic) CGFloat width_map;
@property (nonatomic) CGFloat height_map;
@property (nonatomic) CGFloat centerX_map;
@property (nonatomic) CGFloat centerY_map;
@property (nonatomic) CGSize size_map;
@end

@interface NSString(RVMap)
- (NSString *)MD5String_map;
- (NSArray *)jsonStringToArray_map;
@end

@interface NSData(RVMap)
- (NSString *)MD5String_map;
@end

// params
NSArray * RVMapArray(id array);
NSNumber * RVMapNumber(id number);
NSString * RVMapString(id string);
NSDictionary * RVMapDictionary(id dic);

// color
UIColor *RVMap_H5ColorWithWebString(NSString *colorString);

void RVMapLogInfo(NSString* _Nullable format,...);
NS_ASSUME_NONNULL_END

