//
//  RVMapConfig.h
//  APMap
//
//  Created by 百喻 on 2019/1/18.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface RVMapConfig : NSObject

+ (RVMapConfig *)shared;
/*
 * mapView allowsAnnotationViewSorting
 */
- (BOOL)allowsAnnotationViewSortingWithAppId:(NSString *)appId;

/*
 * mapView markerCount limit
 */
- (NSInteger)maxMarkerCountWithAppId:(NSString *)appId;

/*
 * closeDefaultMarkerImage
 */
- (BOOL)closeDefaultMarkerImageWithConfig;

/*
 * scaledependOnIncludePiont
 */
- (BOOL)scaledependOnIncludePiontConfig;

- (BOOL)needResetIncludePointWithAppId:(NSString *)appId;

- (BOOL)useClusterMarker;

- (BOOL)useAppxMapOptimize;

- (BOOL)openDataLogWithAppId:(NSString *)appId;

- (BOOL)enableLimitRegion;

- (BOOL)getOpenAuthApply;

- (BOOL)degradeLocationFallback;

- (BOOL)enableClusterControl;

- (BOOL)closeDelayRelease;

- (BOOL)closeDelayCreate;

- (BOOL)closeIncludePointDelay:(NSString *)appId;

- (BOOL)openScaleWithIncludePointAppId:(NSString *)appId;

- (BOOL)degradeConvertImage;

- (BOOL)openRestoreMsg;

- (BOOL)closeSkewDelay:(NSString *)appId;

- (BOOL)degradePolylineAni;

- (BOOL)degradeCalculate;

- (BOOL)enableDSLCache;

- (BOOL)enableDSL;

- (BOOL)openMarkerDiff:(NSString *)appId;

- (NSInteger)maxDSLCacheNumber;

- (BOOL)enableCacheUpdate:(NSString *)appId;

- (BOOL)enableWorldMap:(NSString *)appId;

- (BOOL)enableLazyCall;

- (BOOL)enableMapLoadingNotify:(NSString *)appId;

- (BOOL)degradeLazyCreate;

- (BOOL)enablePreCreateTreeAppId:(NSString *)appId;

- (NSString *)useAPImageCacheUrlPrefix:(NSString *)appId;

- (BOOL)closePolylinePause;

- (BOOL)degradeClusterChange;

- (BOOL)openImageDownsampleWithAppId:(NSString *)appId;

- (NSInteger)maxImageCacheNumber;

- (NSDictionary *)APMultiMediaConfig:(NSString *)appId;

- (BOOL)enableWorldVectorMap:(NSString *)appId;

- (BOOL)closeMAMapSDKLog:(NSString *)appId;

- (BOOL)closeParamsCheck:(NSString *)appId;

- (BOOL)enableLocationAuth:(NSString *)appId;

- (BOOL)enableDashLine:(NSString *)appId;

- (BOOL)enableTextAutoFit:(NSString *)appId;

- (NSInteger)useMapEngine:(NSString *)appId;

- (BOOL)degradeLableTap:(NSString *)appId;

- (BOOL)enableHighAccuracy:(NSString *)appId;

- (BOOL)enableIOS14DecreaseFrame:(NSString *)appId;

- (BOOL)closeMemoryRelease;

@end

NS_ASSUME_NONNULL_END
