//
//  RVMapCalloutView.h
//  APMap
//
//  Created by 吴洋 on 2018/7/23.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "RVMapCommonMapLabel.h"

typedef NS_ENUM(NSUInteger, RVMapCalloutViewType) {
    RVMapCalloutViewTypeA = 0,
    RVMapCalloutViewTypeB,
    RVMapCalloutViewTypeC,
    RVMapCalloutViewTypeSubLine,   // 两行模式
};

@class RVZebraView;
@interface RVMapCalloutModel : NSObject
@property (nonatomic, assign) RVMapCalloutViewType type;
@property (nonatomic, strong) NSString *time;
@property (nonatomic, strong) NSArray *descList;
@property (nonatomic, strong) RVMapCommonMapLabel *labelModel;
@property (nonatomic, strong) NSArray *subDescList;
// dsl
@property (nonatomic, strong) NSDictionary *bubbleConfig;
@property (nonatomic, strong) RVZebraView *layoutView;
@end

@interface RVMapCalloutView : UIView

- (instancetype)initWithFrame:(CGRect)frame
                    dataModel:(RVMapCalloutModel *)dataModel;
- (void)updateWithData:(RVMapCalloutModel *)data;

- (BOOL)isEmptyContent;

@end
