//
//  RVMapBaseView.h
//  AriverMap
//
//  Created by 百喻 on 2020/9/11.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "RVMapViewProtocol.h"

//NS_ASSUME_NONNULL_BEGIN

@class RVMAMapClusterMarkerManager;
@interface RVMapBaseView : UIView<RVMapViewProtocol>
- (instancetype)initWithFrame:(CGRect)frame appId:(NSString *)appId;

@property (nonatomic, copy) NSString *appId;
@property (nonatomic, weak) id<RVMapViewDelegate> pDelegate;
@property (nonatomic, weak) id<RVMapViewDataSource> pDataSource;
@property (nonatomic, assign) CLLocationCoordinate2D userCoordinate;

@property (nonatomic, strong) RVMAMapClusterMarkerManager *clusterMarkerMgr;
@property (nonatomic, strong) RVMAMapClusterMarkerManager *collosionMarkerMgr;

@property (nonatomic, strong) NSMutableDictionary *canShowOnTapAnnoDic;
@property (nonatomic, strong) NSMutableDictionary *markerAnimateDic;
@property (nonatomic, strong) NSMutableDictionary *polylineAnimateDic;
@property (nonatomic, strong) NSArray<NSDictionary*> *includePoints;

- (id<RVMapAnnotationProtocol>)findInMapCommonAnnotationWithId:(NSString *)annoId;
- (void)updateAnnotationView:(UIView <RVMapAnnotationViewProtocol> *)annotationView withCommonAnnotation:(id<RVMapAnnotationProtocol>)marker;

// poiTapped
- (void)handlePoiTapped:(NSString *)name latitude:(CLLocationDegrees)latitude longitude:(CLLocationDegrees)longitude;
// tapped
- (void)handleTapped:(CLLocationCoordinate2D)location;
// calloutTapped
- (void)handleCalloutTapped:(id<RVMapAnnotationProtocol>)marker clickId:(NSString *)clickId;
// markerTapped
- (void)handleMarkerTapped:(id<RVMapAnnotationProtocol>)marker;
// regionDidChange
- (void)handleRegionWillChange:(id<RVMapViewProtocol>)mapView byUser:(BOOL)byUser;
- (void)handleRegionDidChange:(id<RVMapViewProtocol>)mapView byUser:(BOOL)byUser;
// translateMarkerEnd
- (void)handleTranslateMarkerEnd:(NSDictionary *)info;

- (void)setVisibleMapRectWithIncludePoints:(NSArray<NSDictionary *> *)incluePoints config:(NSDictionary *)config animated:(BOOL)animated;

- (void)clearRangeDisplayPolygons;
- (void)addRangeDisplayPolygon:(id<RVMapPolygonProtocol>)polygon;
- (void)displayPolygonsWithScale:(CGFloat)scale;


// config
@property (nonatomic) BOOL enableDSLCache;
@property (nonatomic) BOOL degradeClusterChange;
@property (nonatomic) BOOL enableCluster;
@property (nonatomic) BOOL enableWorldVectorMap;
@property (nonatomic) BOOL enableShowRouteDash;
@property (nonatomic) BOOL enableTextAutoFit;
@property (nonatomic) BOOL enableHighAccuracy;
@property (nonatomic) BOOL enableDecreaseFrame;
@property (nonatomic) BOOL degradeLabelTap;
@end

//NS_ASSUME_NONNULL_END
