//
//  TADRemoteDebugPanel.h
//  TinyAppCommon
//
//  Created by 应俊康 on 2018/7/13.
//  Copyright © 2018年 Alipay. All rights reserved.
//

typedef NS_ENUM(NSUInteger, RVDRemoteDebugPanelStatus) {
    RVDRemoteDebugPanelStatusConnecting,
    RVDRemoteDebugPanelStatusConnected,
    RVDRemoteDebugPanelStatusDisconnected,
};

#import <Foundation/Foundation.h>

@class RVDRemoteDebugManager;
@interface RVDRemoteDebugPanel : NSObject

@property (nonatomic,weak) RVDRemoteDebugManager * manager;
@property (nonatomic,weak) RVKSession * session;
@property (nonatomic,assign) BOOL isLinked;

- (void)showMaskWithMessage:(NSString *)message;

- (void)hideMask;

- (void)showLinkStatePanel;

- (void)hideLinkStatePanel;

- (void)hideAll;

#pragma mark - JSApi customization
- (void)showLinkStatePanelWithStatus:(RVDRemoteDebugPanelStatus)status labelText:(NSString *)labelText buttonText:(NSString *)buttonText onClick:(void (^)(void))clickAction;
- (void)showMaskWithMessage:(NSString *)message buttonTitle:(NSString *)buttonTitle onClick:(void (^)(void))clickAction;

@end
