//
//  PSDJSApiRemoteLogEvent.h
//  Nebula
//
//  Created by runfeng.crf on 2018/8/30.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#define kRVDEvent_JSApi_Log_Error @"jsapi.log.error"
#define kRVDEvent_JSApi_Log_HttpRequest @"jsapi.log.httpRequest"

@interface RVDJSApiLogEvent4RemoteDebug : RVKEvent

@property (nonatomic, strong) NSString *jsApiName;
@property (nonatomic, assign) NSInteger errorCode;
@property (nonatomic, assign) NSInteger subCode;
@property (nonatomic, strong) NSString *message;
@property (nonatomic, strong) NSString *desc;
@property (nonatomic, weak) RVKContext *context;

+ (instancetype)errorEventWithName:(NSString *)jsApiName
                              code:(NSInteger)errorCode
                           subCode:(NSInteger)subCode
                           message:(NSString *)message
                              desc:(NSString *)desc
                           context:(RVKContext *)context;

@end


@interface RVDJSApiLogEventHttpRequest : RVKEvent

@property (nonatomic, strong) NSURLRequest *request;
@property (nonatomic, strong) NSHTTPURLResponse *response;
@property (nonatomic, strong) NSData *responseData;
@property (nonatomic, strong) NSError *error;
@property (nonatomic, strong) NSDate *requestTime;

+ (instancetype)eventWithRequest:(NSURLRequest *)request
                        response:(NSHTTPURLResponse *)response
                    responseData:(NSData *)data
                           error:(NSError *)error
                     requestTime:(NSDate *)requestTime;

@end
