//
//  TinyAppDebugProtocol.h
//  TinyAppDebug
//
//  Created by 应俊康 on 2018/7/4.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <AriverKernel/AriverKernel.h>

/**
 小程序调试工具delegate
 */
@protocol RVDDebugProtocol <NSObject>

@required
/**
 当前客户端版本
 */
- (NSString *)currentProductVersion;

/**
 appx离线包的appId
 */
- (NSString *)appxAppId;

/**
 当前appx框架版本
 */
- (NSString *)appxVersion;

/**
 退出当前小程序
 */
- (void)exitTinyAppWithSession:(RVKSession *)session;

/**
 远程调试控制开关
 */
- (BOOL)enableRemoteDebug;

@optional
/**
 调试助手离线包appId
 */
- (NSString *)assistantAppId;

/**
 非插桩模式的调试服务器地址
*/
- (NSString *)remoteDebugServerAddress;

@end


/**
 小程序调试存储类delegate
 */
@protocol RVDDebugStorageProtocol <NSObject>

@optional
/**
 调试信息单独的持久化信息，用于保存面板开启/关闭的状态
 */
- (BOOL)setDebugInfo:(id)info forKey:(NSString *)key;
- (id)debugInfoForKey:(NSString *)key;

@end


/**
 小程序调试UI类delegate
 */
@protocol RVDDebugUIProtocol <NSObject>

@required
/**
 当前客户端语言
 */
- (NSString *)language;

/**
 远程调试显示遮罩之后点击退出按钮的弹窗
 */
- (void)showDialogWithTitle:(NSString *)title message:(NSString *)message cancelButton:(NSString *)cancelTitle otherButton:(NSString *)otherTitle callback:(void (^)(NSUInteger index))callback;

/**
 远程调试遮罩上的弹窗是否已经显示
 */
- (BOOL)dialogHasShown;

/**
 当前的活动页面，用于转发调试消息
 */
- (id<RVKViewControllerProtocol>)currentViewController;

/**
 用于承载调试面板、性能面板和远程调试状态面板的vc
 */
- (UINavigationController *)currentNavigationController;

@optional
/**
 创建非全屏的嵌入式容器，用于加载调试助手
 */
- (RVKWebView *)createWebViewWithVC:(id<RVKViewControllerProtocol>)vc params:(NSDictionary *)params JSApis:(NSDictionary *)jsapis;

/**
 更新右上角菜单中调试按钮状态
 */
- (void)updateMenuOptions;

//调试能力展示文案
- (NSString *)debugPanelStr;
- (NSString *)confirmStr;
- (NSString *)cancelStr;
- (NSString *)exitStr;
- (NSString *)remoteDebugConnectedStr;
- (NSString *)remoteDebugDisconnectedStr;
- (NSString *)remoteDebugExitStr;

@end
