(function(){
	if (window.componentsManager) {
		return;
	}
    function trimStr(str){
        if (str) {
            return str.replace(/^\s*|\s*$/,"");
        }
        return undefined;
    }
    var currentScale;
    var cssCaced = {};
    var componentIds = [];
    var allComponentIds = [];
    var componentsManager = {
          //NBComponent V2 begin
         createAnimationCls:function(css){
            if (typeof css == "string" &&  !cssCaced[css]) {
                var style = document.createElement('style');
                style.type = 'text/css';
                style.rel = 'stylesheet';
                style.appendChild(document.createTextNode(css));
                var head = document.head || document.documentElement;
                if (head) {
                  head.insertBefore(style, head.firstChild);
                }
                cssCaced[css] = "1";
            }
         },
         getScreenScale: function(){
                if (!currentScale) {
                    //compute scale
                    var viewPortTag = document.querySelector("meta[name=viewport]");
                    var viewPortContent;
                    if (viewPortTag) {
                        viewPortContent = viewPortTag.getAttribute("content");
                    };
                    var scaleValue = "0.33";
                    if (window.devicePixelRatio && window.devicePixelRatio > 2) {
                        scaleValue = "0.4235033";
                    };
                    if (viewPortContent) {
                        var contentList = viewPortContent.split(",");
                        for (var item in contentList) {
                            var scaleConfig = contentList[item].split("=");
                            if (scaleConfig && scaleConfig.length > 1) {
                                var scaleName = scaleConfig[0];
                                if (/initial-scale/.test(scaleName)) {
                                    scaleValue = scaleConfig[1];
                                    break;
                                };
                            };
                        }
                    };
                    currentScale = scaleValue;
                }
                return currentScale;
           },
          renderV2Internal: function (element, renderList, parentElementId) {
            var renderObj = {
                frame: {},
                data: {},
                props: {}
            };
            //compute id
            renderObj.id = trimStr(element.getAttribute("id"));

            //compute type
            renderObj.type = trimStr(element.getAttribute("nbcomponent-type"));

            //if is container 
            // if (typeof renderObj.type == "string" && renderObj.type == "container") {
            //  return;
            // }

            //compute scale
            renderObj.scale = componentsManager.getScreenScale();

            //compute frame
            var boundRect = element.getBoundingClientRect();
            renderObj.frame.width = boundRect.width;
            renderObj.frame.height = boundRect.height;

            var scrollLeft = 0;
            if (document.documentElement && document.documentElement.scrollLeft) {
                scrollLeft = document.documentElement.scrollLeft;
            } else if (document.body) {
                scrollLeft = document.body.scrollLeft;
            }
            var x = boundRect.left + scrollLeft;
            renderObj.frame.x = x;

            var scrollTop = 0;
            if (document.documentElement && document.documentElement.scrollTop) {
                scrollTop = document.documentElement.scrollTop;
            } else if (document.body) {
                scrollTop = document.body.scrollTop;
            }
            var y = boundRect.top + scrollTop;
            renderObj.frame.y = y;

            //compute zindex
            if (element.style.zIndex === "") {
                renderObj.frame.zindex = "-9998";
            } else {
                renderObj.frame.zindex = element.style.zIndex;
            }
            if (element.style.zIndex === "" && element.parentElement.style.zIndex != "") {
                renderObj.frame.zindex = (parseInt(element.parentElement.style.zIndex) + 1).toString();
            }

            //compute custom-data
            var customData = trimStr(element.getAttribute("nbcomponent-data"));;
            if (customData) {
                try {
                    var customDic = JSON.parse(customData);
                    for (var key in customDic) {
                        renderObj.data[key] = customDic[key];
                    }
                } catch (ex) {

                }
            };

            if (parentElementId) {
                var style = window.getComputedStyle(element);
                if (style && style.fontFamily) {
                    renderObj.data["NBFONTFAMILY"] = style.fontFamily;
                }
                renderObj.data["NBPARENTELEMENTID"] =  parentElementId;
            }
            if (element.previousSibling && element.previousSibling.id) {
                renderObj.data["NBPREVIOUSSIBLINGID"] =  element.previousSibling.id;
            }
            //compute custom-data
             var customProps = trimStr(element.getAttribute("nbcomponent-props"));;
             if (customProps) {
                 try {
                    var customDic = JSON.parse(customProps);
                    for (var key in customDic) {
                        renderObj.props[key] = customDic[key];
                    }
                 } catch (ex) {

                 }
             };

            renderList.push(renderObj);
        },

        renderV2: function (id) {
            var renderList = [];
            var element = document.getElementById(id);
            if (element) {
                var parentNode = element.parentNode;
                var parentId = null;
                if (parentNode && parentNode.id) {
                    parentId = parentNode.id;
                }
            	this.traverseTree(element, renderList, parentId);
            }
            return JSON.stringify(renderList);
        },

        hasClass: function(elem, className){
            if (elem && className) {
                var classes = elem.className.split(/\s+/);
                for(var i= 0 ; i < classes.length ; i ++) {
                    if( classes[i] === className ) {
                        return true ;
                    }
                }
            }
            return false ;
        },
        addCls:function addClass(ele,cls) {
            if (!this.hasClass(ele,cls)) ele.className += " "+cls;
        },
        traverseTree: function (element, renderList, parentElementId) {
            if (this.hasClass(element, 'nbcomponent')) {
                this.renderV2Internal(element, renderList, parentElementId);
            }
            var nbcomponentType = element.getAttribute("nbcomponent-type");
            if (nbcomponentType && typeof nbcomponentType === "string") {
            	nbcomponentType = trimStr(nbcomponentType);
            }
            //because image is atomaic component we should not get children
            if (!element.children || element.children.length <= 0 || (typeof nbcomponentType == "string" && (nbcomponentType == "image" || nbcomponentType == "text"))) {
                return;
            }
            for (var i = 0; i < element.children.length; i++) {
               this.traverseTree(element.children[i], renderList, element.id);
            }
        },
        //NBComponent V2 end
        getInputElementInfoById:function(id){
            var element = document.getElementById(id);
            var result = {};
            if (element && element.tagName && element.tagName.toLowerCase() == "input" && window.componentsManager.hasClass(element,"a-input-content") && element.getAttribute("data-component-type")) {
                result["element"] = element;
                result["type"] = element.getAttribute("data-component-type");
                result["id"] = id;
                if (element.getAttribute("data-disabled") && element.getAttribute("data-disabled") == "false") {
                    element.setAttribute("disabled","disabled");
                    element.classList.add("nbcomponentinput");
                }
            }
            return result;
        },
        getElementInfoById:function(id){
            var objectElements = Array.prototype.slice.call(document.querySelectorAll("object[type=application\\/view]"));
            var result = {};
            if (objectElements) {
                for(var element in objectElements){
                    var childNodes = Array.prototype.slice.call(objectElements[element].childNodes);
                    if (childNodes) {
                        for(var index in childNodes){
                            var childNode = childNodes[index];
                            var childNodeTag = childNode.tagName;
                            if (childNodeTag && /param/i.test(childNodeTag)) {
                                var name = trimStr(childNode.getAttribute("name"));
                                var value = trimStr(childNode.getAttribute("value"));
                                if(name && value){
                                    result[name] = value;
                                }
                            }
                        }
                    };
                    if (result.id && result.id == id) {
                        result["element"] = objectElements[element];
                        break;
                    };
                }
            };
            if (!result["element"]) {
                result = window.componentsManager.getInputElementInfoById(id);
            }
            return result;
        },
        createTargetAnimationWithId:function(id){
            var clsMode = ".nbcomponentanimation-%@{-webkit-animation:nbcomponentopacity%@ 100s infinite linear}@-webkit-keyframes nbcomponentopacity%@{0%{-webkit-transform:translateZ(0)}100%{-webkit-transform:translateZ(0)}}";
            return clsMode.replace(/%@/g,id);
        },
        addListenerForDomChange:function(){
            var MutationObserver = window.MutationObserver || window.WebKitMutationObserver || window.MozMutationObserver
            var target = document.querySelector('body'); 
            var lastComponentsRect = {};
            var scaleValue = componentsManager.getScreenScale(); 
            var lastObserverData = +new Date();
            var observer = new MutationObserver(function(mutations) {
                // var currentDate = +new Date();
                // if (currentDate - lastObserverData > 30 && allComponentIds && allComponentIds.length > 0) {
                //     AlipayJSBridge.call("NBComponent.setData",{
                //         COMPONENTLAYER:"T"
                //     },function(){});
                // }
                // lastObserverData = currentDate;
                if (Number(scaleValue) != 1) {
                    return;
                }
                if (window && !window.SHOULDUSENEWTOUCHEVENT) {
                    return;
                }
                for(var index in mutations) {
                    var mutation = mutations[index];
                    if (mutation && mutation.type && mutation.type == 'attributes') {
                        if (/pointer-events/.test(mutation.oldValue)) {
                            return;
                        }
                    }
                }
                var componentsRect = {};
                for(var i=0 ;i<componentIds.length; i++){
                    var item = componentIds[i];
                    if (document.getElementById(item)) {;
                        console.log("getDomRectOverComponent  "+ (+ new Date()));
                        var info = componentsManager.getDomRectOverComponent(item);
                        console.log("getDomRectOverComponent  "+ (+ new Date()));
                        if (info && info["rect"]) {
                            componentsRect[item] = info;
                        }
                    }
                }
                if (componentsRect && window.AlipayJSBridge) {
                    if (componentsRect) {
                        var JSONStr = JSON.stringify(componentsRect);
                        var lastJsonStr = JSON.stringify(lastComponentsRect);
                        if (JSONStr == lastJsonStr) {
                            return;
                        }
                    }
                    AlipayJSBridge.call("NBComponent.setData",{
                        COMPONENTRECTDATA:componentsRect
                    },function(){});
                    lastComponentsRect = componentsRect;
                }
            }); 
            var config = { attributes: true, childList: true, subtree: true, attributeFilter: ["class", "style"],attributeOldValue: true} 
            observer.observe(target, config);
        },
        render:function(id){
            var elementInfo = this.getElementInfoById(id);
            if(elementInfo && elementInfo.element){
                componentsManager.createAnimationCls(componentsManager.createTargetAnimationWithId(id));
                var element = elementInfo.element;
                componentsManager.addCls(element,'nbcomponentanimation'+"-"+id);
                var type = elementInfo["type"];
                //if is nbcomponent
                var scaleValue = componentsManager.getScreenScale(); 
                
                var renderObj = {
                                    id:id,
                                    scale:scaleValue,
                                    type:type,
                                    frame:{},
                                    data:{}
                };
                var borderRadius = parseFloat(window.getComputedStyle(element).borderRadius);
                if (borderRadius > 0) {
                    renderObj.borderRadius = borderRadius;
                }
                renderObj.clsName = element.className;

                var boundRect = element.getBoundingClientRect();
                renderObj.frame.width = boundRect.width;
                renderObj.frame.height = boundRect.height;
                
                var scrollLeft = 0;
                if (document.documentElement && document.documentElement.scrollLeft){
                    scrollLeft = document.documentElement.scrollLeft;   
                }else if (document.body){
                    scrollLeft = document.body.scrollLeft;
                }
                var x = element.getBoundingClientRect().left + scrollLeft; 
                renderObj.frame.x = x;

                var scrollTop = 0;
                if (document.documentElement && document.documentElement.scrollTop){
                    scrollTop = document.documentElement.scrollTop;   
                }else if (document.body){
                    scrollTop = document.body.scrollTop;
                }
                var y = element.getBoundingClientRect().top + scrollTop;
                renderObj.frame.y = y;

                //get custom-data
                var customData = elementInfo["data"];
                if (customData) {
                    try{
                        var customDic = JSON.parse(customData);
                        for (var key in customDic){
                            renderObj.data[key] = customDic[key];
                        }
                    }catch(ex){

                    }
                };
                // merge other config to render data obj
                try{
                    for(var key in elementInfo){
                        if (!/^(?:data|id|type|element)$/.test(key)) {
                            renderObj.data[key] = elementInfo[key];
                        };
                    }
                }catch(ex){
                }
                if (componentIds && componentIds.indexOf((id+"")) == -1 && type != "input") {
                    componentIds.push((id+""));
                }
                if(allComponentIds && allComponentIds.indexOf((id+"")) == -1 ){
                    allComponentIds.push((id+""));
                }
                //return config
                return JSON.stringify(renderObj);               
            }
        }
    };
    function onDOMReady(callback) {
        var readyRE = /complete|loaded|interactive/;
        if (readyRE.test(document.readyState)) {
            setTimeout(function() {
                       callback();
                       }, 1);
        } else {
            document.defaultView.addEventListener('DOMContentLoaded', function () {
                callback();
            }, false);
        }
    }

    function isInputTargetWithEvent(e){
        var isNotDisabled = false;
        if (e.target && e.target.id && e.target.getAttribute("data-disabled") &&  e.target.getAttribute("data-disabled") == "false") {
            isNotDisabled = true
        }
        if (e.target && e.target.id && e.target.tagName.toLowerCase() == "object") {
            isNotDisabled = true;
        }
        var istargetInput = (e.target && e.target.id  && window.componentsManager && window.componentsManager.hasClass && window.componentsManager.hasClass(e.target,"nbcomponentanimation"+"-"+e.target.id));
        return istargetInput && isNotDisabled;
    }

    function handleInpageRenderInput(e){
        if (isInputTargetWithEvent(e)) {
            AlipayJSBridge.call("NBComponent.setData",{
                element:e.target.id,
                "TOUCHFROMCOMPONENT":true
            },function(){});
        }
    }

    /*********************component rect *********************/
    function calculateComponentElement(element){
        if (element) {
            var rect = {};
            var boundRect = element.getBoundingClientRect();
            rect.width = boundRect.width;
            rect.height = boundRect.height;
            
            var scrollLeft = 0;
            if (document.documentElement && document.documentElement.scrollLeft){
                scrollLeft = document.documentElement.scrollLeft;   
            }else if (document.body){
                scrollLeft = document.body.scrollLeft;
            }
            var x = boundRect.left + scrollLeft; 
            rect.x = x;

            var scrollTop = 0;
            if (document.documentElement && document.documentElement.scrollTop){
                scrollTop = document.documentElement.scrollTop;   
            }else if (document.body){
                scrollTop = document.body.scrollTop;
            }
            var y = boundRect.top + scrollTop;
            rect.y = y;
            return rect;
        }
        return null;
    }

    function calculateComponentRectWithId(componentId){
        var elementInfo = componentsManager.getElementInfoById(componentId);
        if(elementInfo && elementInfo.element){
           return calculateComponentElement(elementInfo.element);
        }
        return null;    
    }

    function rectGetMinX(rect) {
	    return rect.x;
	};

	function rectGetMinY (rect) {
	    return rect.y;
	};

	function rectGetMaxX (rect) {
	    return (rect.x + rect.width);
	};

	function rectGetMaxY (rect) {
	    return(rect.y + rect.height);
	};

	function rectIntersection (rectA, rectB) {
	    var intersection = {
	    	x: Math.max(rectGetMinX(rectA), rectGetMinX(rectB)),
	    	y: Math.max(rectGetMinY(rectA), rectGetMinY(rectB)),
	    	width: 0,
	    	height: 0
	    };
	  
	    intersection.width = Math.min(rectGetMaxX(rectA), rectGetMaxX(rectB)) - rectGetMinX(intersection);
	    intersection.height = Math.min(rectGetMaxY(rectA), rectGetMaxY(rectB)) - rectGetMinY(intersection);
	    return intersection;
	}

    function rectOverlapsRect(rectA, rectB) {
	    return !((rectA.x + rectA.width < rectB.x) ||
	        (rectB.x + rectB.width < rectA.x) ||
	        (rectA.y + rectA.height < rectB.y) ||
	        (rectB.y + rectB.height < rectA.y));
	}

	function elementsFromPoint(x, y) {
        if (document.elementsFromPoint) {
            return document.elementsFromPoint(x,y);
        }else{
            var elements = [];
            var pointerEvents =[];
            var el;

            do {
                if (el !== document.elementFromPoint(x, y) && el!== document.body) {
                    try{
                        el = document.elementFromPoint(x, y);
                        if (el) {
                            elements.push(el);
                            pointerEvents.push(el.style.pointerEvents);
                            el.style.pointerEvents = 'none';
                        }
                    }catch(ex){
                        console.log(ex);
                    }
                } else {
                    el = null;
                }
            } while (el);

            for (var i = 0; i < elements.length; i++) {
                var item = elements[i];
                if (item) {
                    item.style.pointerEvents = pointerEvents[i];
                }
            }

            return elements;
        }
	}

    function isElementResponseForPoint(rectValueIntersection,element){
        if (element) {
            if (document && document.elementFromPoint(Math.max(rectValueIntersection.x,0),Math.max(rectValueIntersection.y,0)) === element) {
                return true;
            }
        }
        return false;
    }

    function isElementShow(element){
        if (element && (element.style.display == "none" || window.getComputedStyle(element).opacity == "0")) {
            return false;
        }
        return true;
    }

    function getDomRectOverComponent(id){
        var componentRectInfo = {};
        var rect = calculateComponentRectWithId(id);
        var compoenntElement = document.getElementById(id);
        if (rect && compoenntElement && document.body) {
            componentRectInfo["rect"] = rect;
            var allElements = document.body.querySelectorAll(".NebulaComponentOverLayer");
            if (!allElements || (allElements && allElements.length == 0)) {
                allElements = document.body.querySelectorAll(".AF-COMPONENT-OVERLAYER");
                var empty = !allElements || (allElements && allElements.length == 0);
                if (empty && window.AlipayJSBridge && window.AlipayJSBridge.startupParams && window.AlipayJSBridge.startupParams.enableComponentOverlayer) {
                    allElements = [null];
                }
            }
            if (!allElements || (allElements && allElements.length == 0)) {
                allElements = document.body.querySelectorAll("*");
            }else{
                var targetList = [].slice.call(allElements);
                for (var j = 0; j < targetList.length; j++) {
                    var item = targetList[j];
                    if (!item) {
                        continue;
                    }
                    if (!componentRectInfo["overlay"]) {
                        componentRectInfo["overlay"] = [];
                    }
                    var itemRect = calculateComponentElement(item);
                    componentRectInfo["overlay"].push(itemRect);
                }
                return componentRectInfo;
            }            
	        var elements = [].slice.call(allElements);
	        var possibleElement = [];
	        for (var i = elements.length - 1; i >= 0; i--) {
	            var element = elements[i];
                var nodeName = element.nodeName;
                var regTest = /script|style|param|link/i;
                if (!nodeName || regTest.test(nodeName)) {
                    continue;
                }
	            var elementRect = calculateComponentElement(element);
	            //if componentrect contains elementrect and current element is target element
	            if (isElementShow(element) && elementRect && rectOverlapsRect(rect,elementRect) ) {
	            	var rectValueIntersection =  rectIntersection(rect,elementRect);
	            	var elementsForRectValueIntersection = elementsFromPoint(rectValueIntersection.x,rectValueIntersection.y);
	            	for (var j = 0; j < elementsForRectValueIntersection.length; j++) {
	            		var item = elementsForRectValueIntersection[j];
	            		if (item === compoenntElement) {
	            			break;
	            		}else{
	            			if (!possibleElement.indexOf(item)!= -1) {
	            				if (!componentRectInfo["overlay"]) {
				                    componentRectInfo["overlay"] = [];
				                }
                                var targetRect = null;
				                if (item === element) {
                                    targetRect = elementRect;
				                }else{
                                    var itemRect = calculateComponentElement(item);
                                    if (itemRect) {
                                        targetRect = itemRect;
                                    }
				                }
                                if (targetRect) {
                                    componentRectInfo["overlay"].push(targetRect);
                                    possibleElement.push(item);
                                }
	            			}else{
	            				continue;
	            			}
	            		}
	            	}
	            }
	        }
        }
        return componentRectInfo;
    }
    componentsManager.getDomRectOverComponent = getDomRectOverComponent;

    /*********************component end *********************/


    window.componentsManager = componentsManager;
    onDOMReady(function(){
        if (!window.hasAddInputTouchListener) {
            componentsManager.createAnimationCls("body .a-input input.nbcomponentinput:disabled{opacity: 1.0;}");
            document.addEventListener("touchend",function(e){
                handleInpageRenderInput(e);
            },false);
            window.hasAddInputTouchListener = true;
            componentsManager.addListenerForDomChange();
        }
    });
})();
