//
//  RVDBLEDeviceInfo.h
//  RVDBLESDK
//
//  Created by Ethan on 01/06/2017.
//  Copyright © 2017 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreBluetooth/CoreBluetooth.h>
#import "RVDBLESemaphoreContext.h"

@interface RVDBLEDeviceInfo : NSObject
/**
 用来持有 CBPeripheral 对象，CBPeripheral 对象在销毁的时候会主动断开连接
 */
@property (nonatomic, strong)   CBPeripheral    *peripheral;
@property (nonatomic, strong)   RVDBLESemaphoreContext   *connectSemaphore;
@property (nonatomic, strong)   RVDBLESemaphoreContext   *disconnectSemaphore;
@property (nonatomic, strong)   RVDBLESemaphoreContext   *serviceSemaphore;
@property (nonatomic, strong)   RVDBLESemaphoreContext   *characteristicSemaphore;
@property (nonatomic, strong)   RVDBLESemaphoreContext   *readSemaphore;
@property (nonatomic, strong)   RVDBLESemaphoreContext   *writeSemaphore;
@property (nonatomic, strong)   RVDBLESemaphoreContext   *readRSSISemaphore;

@property (nonatomic, assign) NSUInteger reconnectCount;

@property (nonatomic, strong)   NSDictionary    *advertisementData;
@property (nonatomic, copy)     NSNumber        *RSSI;
@property (nonatomic, copy)     NSString        *deviceName;
@property (nonatomic, strong)   NSUUID          *deviceUUID;

@property (nonatomic, copy, readonly)     NSString        *localName;
@property (nonatomic, strong, readonly)   NSData          *manufacturerData;
@property (nonatomic, copy, readonly)     NSString        *manufacturerDataHexString;
@property (nonatomic, strong, readonly)   NSArray <CBUUID *> *advertisementServiceUUIDs;

- (NSDictionary*)toDictionary;

+ (NSString *)dataToHexString:(NSData *)data;
+ (NSData *)hexStringToData:(NSString *)string;

@end
