//
//  RVAEventAdapterDefine.h
//  AriverApp
//
//  Created by hua.lu on 2019/4/23.
//  Copyright © 2019 Alipay. All rights reserved.
//

#ifndef RVAEventAdapterDefine_h
#define RVAEventAdapterDefine_h


/*----------------------------------
 独立文件，标注event迁移状态
 ----------------------------------*/


// session 事件

#define kNBEvent_Session_Pause         @"session.pause"   // 保活功能，退出使用，到后台保活
#define kNBEvent_Session_Resume        @"session.resume"  // 保活功能，从后台保活恢复使用
#define kNBEvent_Session_Hide          @"session.hide"    // 应用被暂停，不包括保活场景
#define kNBEvent_Session_Reshow        @"session.reshow"  // 应用重新回到最上层，不包括从后台保活唤起

// 已列全
/*----------------------------------NXAExtension4NavigationItem----------------------------------*/
#define kNBEvent_Scene_NavigationItem_Left_Back_Create_Before       @"scene.navigationItem.left.back.create.before"
#define kNBEvent_Scene_NavigationItem_Left_Close_Create_After       @"scene.navigationItem.left.close.create.after"
#define kNBEvent_Scene_NavigationItem_Left_Back_Click               @"scene.navigationItem.left.back.click"
#define kNBEvent_Scene_NavigationItem_Left_Close_Click              @"scene.navigationItem.right.close.click"
#define kNBEvent_Scene_NavigationItem_Left_Close_Create_Before      @"scene.navigationItem.left.close.create.before"
#define kNBEvent_Scene_NavigationItem_Left_Back_All                   @"scene.navigationItem.left.back.*"
#define kNBEvent_Scene_NavigationItem_Left_Close_All                  @"scene.navigationItem.left.close.*"
#define kNBEvent_Scene_NavigationItem_Left_Back_Create_After          @"scene.navigationItem.left.back.create.after"
#define kNBEvent_Scene_NavigationItem_Right_Setting_Create_Before   @"scene.navigationItem.right.setting.create.before"
#define kNBEvent_Scene_NavigationItem_Right_Setting_Create_After    @"scene.navigationItem.right.setting.create.after"
#define kNBEvent_Scene_NavigationItem_Right_Setting_Click          @"scene.navigationItem.right.setting.click"
#define kNBEvent_Scene_NavigationItem_Right_Setting_Change          @"scene.navigationItem.right.setting.change"
#define kNBEvent_Scene_NavigationItem_Right_Setting_All               @"scene.navigationItem.right.setting.*"
#define kNBEvent_Scene_NavigationItem_Right_SubSetting_Create_After @"scene.navigationItem.right.subsetting.create.after"
#define kNBEvent_Scene_NavigationItem_Right_SubSetting_Create_Before  @"scene.navigationItem.right.subsetting.create.before"
#define kNBEvent_Scene_NavigationItem_Right_SubSetting_Click          @"scene.navigationItem.right.subsetting.click"

// 已列全
/*----------------------------------NXAExtension4TitleView----------------------------------*/
#define kNBEvent_Scene_TitleView_Subtitle_Click                     @"scene.titleView.subtitle.click"
#define kNBEvent_Scene_TitleView_Create_Before                      @"scene.titleView.create.before"
#define kNBEvent_Scene_TitleView_Create_After                       @"scene.titleView.create.after"
#define kNBEvent_Scene_TitleView_RightIcon_Click                    @"scene.titleView.righticon.click"
#define kEvent_Scene_Security_Tipview_Show                          @"scene.securitytipview.show"
#define kNBEvent_Scene_TitleView_Title_Set                          @"scene.titleView.title.set"
#define kNBEvent_Scene_TitleView_Title_Click                        @"scene.titleView.title.click"
#define kNBEvent_Scene_TitleView_All                                @"scene.titleView.*"


/*----------------------------------NXAExtension4SearchBar----------------------------------*/
//kEvent_Scene_Appear_After
#define kH5Event_Scene_NavigationBar_ChangeColor                    @"scene.NavigationBar.ChangeColor"

// 已列全
//----------------------------------------ToolBar Event------------------------------------------------------------------------
#define kNBEvent_Scene_ToolbarMenu_Create_Before           @"scene.toolbarMenu.create.before"
//#define kNBEvent_Scene_ToolbarMenu_Create_After            @"scene.toolbarMenu.create.after"
//#define kNBEvent_Scene_ToolbarMenu_Select                  @"scene.toolbarMenu.select"
//#define kNBEvent_Scene_ToolbarMenu_Create_All              @"scene.toolbarMenu.*"
#define kNBPrivateEvent_Scene_ToolbarMenu_Show       @"private.scene.toolbarMenu.show"
#define kNBPrivateEvent_Scene_ToolbarMenu_Hide       @"private.scene.toolbarMenu.hide"

// 已列全
/*----------------------------------------progress View----------------------------------------*/
#define kNBEvent_Scene_ProgressView_Create_Before          @"scene.progressView.create.before"
#define kNBEvent_Scene_ProgressView_Create_After           @"scene.progressView.create.after"
//#define kNBEvent_Scene_ProgressView_Create_All             @"scene.progressView.create.*"

#define kNBEvent_Scene_ContentView_Fallback                @"scene.ContentView.Fallback"

/*---request---*/
#define kNBEvent_Scene_LoadRequest_First                   @"scene.loadRequest.first"
//#define kNBEvent_Scene_LoadRequest_All                     @"scene.loadRequest.*"

// 已列全
//----------------------------------------nxkNaviaget(RVKPage)Events----------------------------------------//
#define kEvent_Page_Create                      @"page.create"
#define kEvent_Page_Load_Start                  @"page.load.start"
#define kEvent_Page_Load_FirstByte              @"page.load.firstbyte"
#define kEvent_Page_Load_Progress               @"page.load.progress"
#define kEvent_Page_Load_DomReady               @"page.load.domready"
#define kEvent_Page_Load_Complete               @"page.load.complete"
#define kEvent_Page_Load_Error                  @"page.load.error"
#define kEvent_Page_Destroy                     @"page.destroy"
#define kEvent_Page_All                         @"page.*"

//----------------------------------------------------------------------------------------------------------------

//**********************Proxy      Events***********************//
/*
 * 监听该事件，可以调用preventDefault阻止默认行为（默认是将要开始加载请求），
 * 如阻止了，则不会进行加载；若要自定义请求，则可以设置`request`或者设置其headers
 */
#define kEvent_Proxy_Request_Start_Handler      @"proxy.request.start.handle"
#define kEvent_Proxy_Request_Start_Dest         @"proxy.request.start.dest"

/*
 *
 * 监听该事件，可以调用preventDefault阻止默认行为（默认是继续加载请求），
 * 若阻止了默认行为，则可以设置`willRedirectRequest`、并会重定向到当前的`request`（一般用途是处理登录后重新发出请求）
 */
#define kEvent_Proxy_Request_Response_Handler   @"proxy.request.response.handle"

/*
 *
 * 监听该事件，可以处理`response`，比如修改或者新增headers
 */
#define kEvent_Proxy_Request_ReceiveResponse    @"proxy.request.response.receive"
#define kEvent_Proxy_Request_Redirect_Before    @"proxy.request.redirect.before"

/*
 *
 * 监听该事件，可以处理`willHoldReceiveData`和`reveiceData`，
 * 如果willHoldReceiveData=YES，则数据会被暂时持有在内存 处理：分段data，处理过程中不会response已有的receive data
 */
#define kEvent_Proxy_Request_ReceiveData        @"proxy.request.data.receive" 

/*
 *
 * 监听该事件，可以处理`receiveData` 处理：完整data，并response回去
 */
#define kEvent_Proxy_Request_FinishReceiveData  @"proxy.request.data.finish"
#define kEvent_Proxy_Request_Finish             @"proxy.request.finish"
#define kEvent_Proxy_Request_Finish_Metrics     @"proxy.request.finish.metrics"
#define kEvent_Proxy_Request_Cancel             @"proxy.request.cancel"   //请求取消事件


//**********************Prerender      Events***********************//
#define kH5Event_Scene_Pre_Render               @"scene.pre.render"

#endif /* RVAEventAdapterDefine_h */

