//
//  TAFileManager.h
//  TinyAppCommon
//
//  Created by ZQP on 2018/9/19.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface TAFileManager : NSObject

@property (nonatomic, readonly) dispatch_queue_t queue;

+ (instancetype)sharedInstance;

// 创建用户目录
- (BOOL)createUsrDirectory:(NSString *)appId;

// 文件追加是否超限
+ (BOOL)overMaxSizeWithAppId:(NSString *)appId fileSize:(float)fizeSize error:(NSError **)error;

// 写入文件编码处理
+ (NSData *)contentToData:(id)content encoding:(NSString *)encoding dataType:(NSString *)dataType;

// 判断文件是否存在
+ (BOOL)isFileExistAtPath:(NSString *)filePath;

// 指定文件路径的上级目录是否存在
+ (BOOL)isParentDirectoryExistAtPath:(NSString *)filePath;

// 判断是否文件夹目录
+ (BOOL)isDirectoryAtPath:(NSString *)path;


@end

NS_ASSUME_NONNULL_END
