//
//  UIView+AUKRenderExtend.h
//  AntUIKit
//
//  Created by JL on 2020/2/17.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

//
@interface AUKCustomRenderEventModel : AUKEventLogModel

//必填参数
@property (nonatomic, copy) NSString           *xPath;        //曝光控件路径（xPath）

//必填参数， 需要考虑cell复用场景
@property (nonatomic, copy) NSString           *target;       //控件实例标识（Hash Code）

// 必填参数，主要用于根据当前的视图bounds来计算视图百分比。
@property (nonatomic, assign) CGRect bounds;
@property (nonatomic, assign) NSInteger exposurePercent;    //曝光比例0-100

// 非必填，无障碍信息，仅点击时设置即可
@property (nonatomic, strong) NSDictionary *accessibilityInfo_auk;

@end

// CardSDK处理完回调block
typedef void (^AUKRenderCompletionBlock)(NSArray<AUKCustomRenderEventModel *> * models);

// AntUIKit 调用 CardSDK block
// preIdentifier: 壳view的identifier
typedef void (^AUKRenderEventLogBlock)(NSString *preIdentifier, AUKRenderCompletionBlock completionBlock);

@interface UIView (AUKRenderExtend)

// 设置曝光埋点block
- (void)setupCustomRenderExposureEventBlock_auk:(AUKRenderEventLogBlock)block;

// 更新曝光接口
- (void)updateCustomRenderExposureEvent_auk;

// cube区块点击事件埋点
- (void)commitCustomRenderClickEvent_auk:(AUKCustomRenderEventModel *)model;

@end

NS_ASSUME_NONNULL_END
