#import <AntUI/AUUILoadDefine.h>
#ifdef ANTUI_UI_BaseComponent_AUView//程序自动生成
//
//  AUView.h
//  AntUI
//
//  Created by maizhelun on 2017/7/7.
//  Copyright © 2017年 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>

AntUI_BaseComponent

//注明实现这个协议的控件均已经支持屏幕适配
@protocol AUScreenScaleSupport

-(void) au_isScreenScaleSupport:(BOOL) isSupport;

@end

//注明实现这个协议的控件均已经支持大字体
@protocol AUScalingModelSupport


@end

CGFloat AUScalingFloat(CGFloat origin,UIView *view);
//以1.375作为最大比例，按照比例放大到Max
//会先去view的放大比例，如果没有view或者没有设置放大比例，取统一设置放大比例
CGFloat AUScalingLimitFloat(CGFloat origin,CGFloat max,Class viewClass);

CGFloat AUGetCurrentScale(Class viewClass);


@interface UIView (AUScalingExtention)

@property (nonatomic,strong) AUScalingModel *au_scalingModel;

@property (nonatomic,strong) NSString *au_universeIdentifer;

@end

@interface UIView (AUScreenScaleSupport)

@property (nonatomic,assign) BOOL au_screenScaleSupport;

-(void) au_isScreenScaleSupport:(BOOL) isSupport;

@end



//注明实现这个协议的控件支持UEP埋点
@protocol AUUEPSupport

@end


//注明实现这个协议的 DataModel支持UEP埋点,可以设置au_uepDataModel
@protocol AUUEPModelSupport


// Copy From  https://code.alipay.com/wallet/ios-phone-antuikit/commit/33f9a9cfaf369f752e956f634897193d8fe16688
// spmInfo
//    String spm;
//    String scm;
//    String bizCode;
//    Map<String, String> params;
@property (nonatomic,strong) NSDictionary *au_uepDataModel;


@end

@interface NSObject (UEPSupport)

//UEP的数据模型
@property (nonatomic,strong) NSDictionary *au_uepDataModel;

@end



@interface AUView : AUKView

@property (nonatomic, strong) UIView *aubadgeView; // 带有红点的共有view
@property (nonatomic, assign) CGRectEdge aubadgeViewEdge; // 设置红点的与旁边view的间距

@property (nonatomic, strong) AUView *auMaskView;

@end




@interface UIView (AUBadgeView)

/**
 设置红点
 
 @param wedgetId 红点的wedgetId
 @param badgeNumber @"."   显示红点
 @"new" 显示new
 @"数字" 显示数字，大于99都显示图片more（...）
 @"惠"/"hui"  显示“惠”字
 @"xin" 显示"新"字
 nil    清除当前显示
 */

/**
 *  如果设置了widgetId，就不需要设置badgeNumber
 */
@property (nonatomic, strong) NSString *aubadgeNumber;

/**
 *  红点显示的widgetId
 */
//@property (nonatomic, copy) NSString *aubadgeWidgetId;

@end

typedef NS_ENUM(NSInteger, AUViewPaddingPostion) {
    AUViewPaddingPostionLeft,          // regular table view
    AUViewPaddingPostionRight,         // preferences style table view
    AUViewPaddingPostionTop,
    AUViewPaddingPostionBottom,
    AUViewPaddingPostionBadgeNumber,
    AUViewPaddingPostionBadgeWidgetId,
    AUViewPaddingPostionBottomLeft,
};

@interface UIView (PaddingView)

- (UIView *)au_paddingViewAtPostion:(AUViewPaddingPostion)postion;
- (void)au_setPaddingView:(UIView *)view atPostion:(AUViewPaddingPostion)postion;
- (void)au_removePaddingViewAtPosition:(AUViewPaddingPostion)postion;

@end


typedef void (^AUViewActionBlock)();
@interface UIView (AUAction)

@property (nonatomic, copy) AUViewActionBlock auviewActionBlock;  //点击事件

@end

@interface AUControl : UIControl

@end

#endif//程序自动生成
