//
//  AUV2PopTipView.h
//  AntUI
//
//  Created by Wang on 2020/4/23.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "AUImageLottieViewModel.h"

@class AUV2PopContentView;

@interface AUV2PopTipView : AUPopDrawBoardView

/**
 * 点击close的时候回去执行代码
 * 如果不设置默认是关闭自己，如果设置了就按照传入的block来
 */
@property (nonatomic, copy) void (^actionOnClose)(AUV2PopTipView *tipView);

@property (nonatomic, strong) NSNumber *maxWidth;

/**
* 点击按钮时执行代码
* @return 返回YES表明用动画关闭,返回NO表示不关闭
*/@property (nonatomic, copy) BOOL (^actionOnButtonAction)();

-(instancetype)initWithText:(NSString *)text
                buttonTitle:(NSString *)buttonTitle
               buttonAction:(BOOL(^)())actionBlock;

-(instancetype) initPopBarWithText:(NSString *)text
                       buttonTitle:(NSString *)buttonTitle
                      buttonAction:(BOOL(^)())actionBlock;

-(instancetype) initTopBottomPopBarWithText:(NSString *)text
                       buttonTitle:(NSString *)buttonTitle
                               buttonAction:(BOOL(^)())actionBlock;

-(instancetype) initPopBarWithIcon:(AUImageViewModel *)iconViewModel
                        Text:(NSString *)text
                       buttonTitle:(NSString *)buttonTitle
                      buttonAction:(BOOL(^)())actionBlock;

/// 支持带Lottie动画 且 支持富文本 的PopBar样式弹窗
/// 内部元素布局为横条布局
-(instancetype) initPopBarWithLottieIcon:(AUImageLottieViewModel *)iconViewModel
                          attributedText:(NSAttributedString *)text
                       buttonTitle:(NSString *)buttonTitle
                      buttonAction:(BOOL(^)())actionBlock;

/// 支持传统图片 且 支持富文本 的PopBar样式弹窗
/// 内部元素布局为横条布局
-(instancetype) initPopBarWithIcon:(AUImageViewModel *)iconViewModel
                          attributedText:(NSAttributedString *)text
                       buttonTitle:(NSString *)buttonTitle
                      buttonAction:(BOOL(^)())actionBlock;

/**
 * 建议使用这种方式，屏幕适配
 * Example:
    AUV2PopTipView *tipView = [[AUV2PopTipView alloc] init];
    tipView
      
    [tipView loadData:^(AUV2PopContentView *v) {
        v.style = AUPopContentViewStyleAUPopTip;
        v.textLabel.text = @"单行";
        [v.button setTitle:@"确定确定" forState:UIControlStateNormal];

    }];
 */
-(void) loadData:(void(^)(AUV2PopContentView *)) block;


/**
 * 内容具体块,如果是自定义的，返回空
 */
- (AUV2PopContentView *) contentView;



@end
