//
//  AUV2PopContentView.h
//  AntUI
//
//  Created by Wang on 2020/4/23.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>

#import <AntUI/AUPopTipContentView.h>

@class AUV2PopContentViewConfig;

@interface AUV2PopContentView : AUView<AUScreenScaleSupport,AUScalingModelSupport>
{
    @public
    AUButton *_button;
    AUExpandAreaButton *_closeButton;
}

@property (nonatomic, assign) AUPopContentViewStyle style;
@property (nonatomic, strong) AUIImageView *iconView;
@property (nonatomic, strong) UILabel *textLabel;
@property (nonatomic, strong) AUButton *button;
@property (nonatomic, strong) AUExpandAreaButton *closeButton;
@property (nonatomic, strong) AUV2PopContentViewConfig *config;
@property (nonatomic, assign) AUPopContentViewBarStyle barStyle;


- (void)setMaxWidth:(CGFloat)width;

//普通气泡样式。
//带右侧X按钮，纯文本 + 纯按钮
- (instancetype)initCloseBtnWithTitle:(NSString *)title
                  buttonTitle:(NSString *)buttonTitle;
/**
 * 推荐使用这种方式。
 *
 */
- (void) loadData:( BOOL(^)(AUV2PopContentView *))block;

@end



@interface AUV2PopContentViewConfig : NSObject

@property (nonatomic,strong) NSNumber *edgeMargin; //左右边距,默认16
@property (nonatomic,strong) NSNumber *icon_labelMargin; //icon与文本之间的间距


@end
