//
//  AUV2FloatMenu.h
//  AntUI
//
//  Created by Wang on 2020/4/22.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <AntUI/AntUI.h>

NS_ASSUME_NONNULL_BEGIN


@protocol AUV2FloatMenuDelegate;

typedef NS_ENUM(NSInteger,AUV2FloatMenuRightViewStrategy)
{
    AUV2FloatMenuRightViewStrategyKeep //一直在
    //AUV2FloatMenuRightViewDisappearStrategyPlaceHolder,//占位,点击消失也是站位
};


@interface AUV2FloatMenuControl<T> : AUKControl
{
    @public
    NSInteger _index;
}

@property (nonatomic,strong) AUIImageView *imageView;

@property (nonatomic,strong) UILabel *titleLabel;

@property (nonatomic,strong) UIView *rightView;
@property (nonatomic,assign) AUV2FloatMenuRightViewStrategy rightViewStrategy;
@property (nonatomic,assign) CGSize rightViewIntrinsicSize;

@property (nonatomic,strong) T extInfo;

//设置了点击就会回调的。
@property (nonatomic,copy) void(^AUV2FloatMenuControlClickBlock)(AUV2FloatMenuControl *);

-(void) loadData:( void (^)(AUV2FloatMenuControl *)) block;

-(void) updateData:( void (^)(AUV2FloatMenuControl *)) block;

@end

typedef void (^AUV2FloatMenuControlClickBlock)(AUV2FloatMenuControl *);




/**
 *
 *菜单控件，
 *支持字体放大： menu.au_scalingModel = AUScalingModelMake(2.0);
 */
@interface AUV2FloatMenu : AUPopDrawBoardView


-(AUV2FloatMenuControl *) addFloatMenuItem:(AUV2FloatMenuControl *)control;


-(AUV2FloatMenuControl *) addFloatMenuItemBlock:(void (^)(AUV2FloatMenuControl*))itemBlock click:(AUV2FloatMenuControlClickBlock)block;


-(AUV2FloatMenuControl *) addFloatMenuItem:(AUV2FloatMenuControl*)control click:(AUV2FloatMenuControlClickBlock)block;


-(void) updateItem:(AUV2FloatMenuControl *)item;

@end



NS_ASSUME_NONNULL_END
