//
//  AUToDoDatePickerDialog.h
//  AntUIDemoPortal
//
//  Created by 胡胡超 on 2022/6/27.
//  Copyright © 2022 Alipay. All rights reserved.
//

#import <AntUI/AntUI.h>

NS_ASSUME_NONNULL_BEGIN

@class AUToDoDatePickerDialog;

@protocol AUToDoDatePickerDelegate <NSObject>

/*
 * 点取消时回调
 */
- (void)cancelPickerView:(AUToDoDatePickerDialog *)pickerView;

/*
 * 点完成时回调，选中项可通过 selectedRowInComponent返回
 */
- (void)selectedPickerView:(AUToDoDatePickerDialog *)pickerView
               currentMode:(AUCustomDatePickerMode)AUCustomDatePickerMode
              selectedDate:(NSDate *)selectedDate;

@end

@interface AUToDoDatePickerModel: NSObject
@property(nonatomic, assign)AUCustomDatePickerMode mode;
@property(nonatomic, strong)NSDate *selectedDate;
@property(nonatomic, strong)NSDate *minDate;
@end

@interface AUToDoDatePickerDialog : AUNoticeDialog
+(instancetype)dialogModelList:(NSArray<AUToDoDatePickerModel *>*)modelList
                       delegte:(id<AUToDoDatePickerDelegate>)delegte;
@property(nonatomic, assign)AUCustomDatePickerMode currentMode;

@end

NS_ASSUME_NONNULL_END
