//
//  AUStatusBar.h
//  AntUI
//
//  Created by Wang on 2020/10/1.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger,AUStatusBarStyle)
{
    AUStatusBarStyleWarning,
    AUStatusBarStyleNoticeVenti,//圆角
};

@interface AUStatusBar : UIControl
@property (nonatomic,strong) UIView *leftView;
@property (nonatomic,strong) UILabel *titleLabel;
@property (nonatomic,strong) UIView *rightView;

@property (nonatomic,assign) CGFloat maxWidth;

@property (nonatomic,copy) void(^ClickAction)(AUStatusBar *bar);

-(id) initWithStyle:(AUStatusBarStyle)style;

-(void) updateBlock:(void(^)(AUStatusBar *bar))block;

@end

NS_ASSUME_NONNULL_END
