#import <AntUI/AUUILoadDefine.h>
#ifdef ANTUI_UI_Segment_AUSegment//程序自动生成
//
//  AUSegmentedControlItem.h
//  AntUI
//
//  Created by sara on 16/9/28.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <AntUI/AUView.h>
#import <AntUI/AUSegmentPublic.h>
#define kBadgeLabelReserveWidth  1

extern NSString *kAUBadgeViewOffsetXInAUSegmentControllItemKey;
extern NSString *kAUBadgeViewOffsetYInAUSegmentControllItemKey;

@class AUSegmentedControlItem;

@protocol AUSegmentedControlItemDelegate <NSObject>

- (void) ausegmentedControlItemClicked:(AUSegmentedControlItem *)item;

@end

@interface AUBadgeLabel : AUView

@property (nonatomic, strong)   AUSegmentStyle *style;

@property (nonatomic, strong) UILabel *titleLabel;

@property (nonatomic, assign) BOOL selected;

/// 是否启用新特性
/// 包含字体会变大
/// 选中条可以滑动
@property (nonatomic, assign) BOOL enableNewFeature;

/// 用于指示badgeView的偏移量
@property (nonatomic, assign) CGPoint badgeViewOffset;
/// 设置AUBadgeLabel中的角标
/// - Parameters:
///   - aubadgeNumber: 角标的内容
///   - extInfo: 角标的额外附加信息，例如圆角的位置，角标偏移的位置
- (void)setAubadgeNumber: (NSString *)aubadgeNumber WithExtensionInformation: (NSDictionary *)extInfo;

@end

@interface AUSegmentedControlItem : UIView<AUSegmentedControlCustomViewDelegate>

@property (nonatomic, weak)     id <AUSegmentedControlItemDelegate> delegate;
@property (nonatomic, strong)   AUSegmentStyle *style;
@property (nonatomic, copy)     NSString *title;
@property (nonatomic, strong)   AUBadgeLabel *badgeLabel;
@property (nonatomic, assign)   BOOL selected;

@property (nonatomic, strong)   AUImageViewModel *imageViewModel;

@property (nonatomic, assign)   UIEdgeInsets contentInsets;

/// 是否启用新特性
/// 包含字体会变大
/// 选中条可以滑动
@property (nonatomic, readonly) BOOL enableNewFeature;

- (instancetype)initWithFrame:(CGRect)frame title:(NSString*)title;


- (instancetype)initWithFrame:(CGRect)frame title:(NSString*)title enableNewFeature: (BOOL) enable;
//- (void)addTarget:(id)target action:(SEL)action;


/// 设置AUBadgeLabel中的角标
/// - Parameters:
///   - imageViewModel: 角标的图片数据模型
///   - extInfo: 角标的额外附加信息，例如角标偏移的位置
-(void) setImageViewModel:(AUImageViewModel *)imageViewModel WithExtensionInformation:(NSDictionary *)extInfo;

@end

#endif//程序自动生成
