//
//  AUSegmentPublic.h
//  AntUI
//
//  Created by Wang on 2021/5/11.
//  Copyright © 2021 Alipay. All rights reserved.
//



@class AUSegmentStyle;

@protocol AUSegmentedControlCustomViewDelegate <NSObject>

@required
/*
 * 返回内容区的固有内容大小，不随着空白区域增加而增加的。
 * 用于蓝条宽度。
 * @param size，整个AUSegment控件大小
 */
-(CGSize) contentSizeThatFits:(CGSize)size;

/*
 * 都会回调该方法。
 * 如果有多余的空间，给定新的size，如果没有，会给contentSizeThatFits的大小。
 * @param size，新的Size大小。新的Size大小肯定>=contentSizeThatFits返回的大小。
 * @param contentSize, contentSizeThatFits返回的大小；
 * 最终通过这个回调方法改变自身的size。
 */
-(void) acceptAvailibleSize:(CGSize)size contentSize:(CGSize)contentSize;

/*
 * 返回外边距
 * 用于撑大空间，但又不影响蓝条宽度,外边距空间不属于自己的空间。
 */
-(UIEdgeInsets) contentMargin;

@property (nonatomic,assign) BOOL selected;

@end
