#import <AntUI/AUUILoadDefine.h>
#ifdef ANTUI_UI_Segment_AUSegment//程序自动生成
//
//  AUSegment.h
//  AntUI
//
//  Created by sara on 16/9/28.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import <AntUIKit/AntUIKit.h>
#import <AntUI/AUSegmentPublic.h>
#import <AntUI/AUSegmentedControlItem.h>
#import <AntUI/UIView+Helper.h>


#define UI_AUSegment

@class AUSegment;
@class AUSegmentItemModel;
@class AUSegmentStyle;

@protocol AUSegmentedControlDelegate <UIScrollViewDelegate>
//AUSegment点击事件回调
@optional

- (void)didSegmentValueChanged:(AUSegment*)segmentControl;

- (void)didSelectSegmentItemModel:(AUSegmentItemModel*)selectedItemModel;//

- (void)didSelectSegent:(AUSegment *)segment withItemModel:(AUSegmentItemModel*)selectedItemModel;

@end

@protocol AUSegmentedControlDataSource <NSObject>

@required
/**
 * 一共有多少个子视图
 * @return 视图个数
 */
-(NSInteger) numberOfCustomViewInSegmentedControl:(AUSegment *)segment;

/**
 *返回子视图
 */
-(UIView<AUSegmentedControlCustomViewDelegate> *) customViewInSegmentedControl:(AUSegment *)segment atIndex:(NSInteger)index;



@optional

/**
 * 固定在右侧的View
 * 如果存在可滚动区域会减去这个View。
 */
-(UIView *) fixedRightViewFor:(AUSegment *)segment;

/**
 *
 *当有足够空间的时候，是否要增大空间撑满
 *默认返回NO
 *
 */
-(BOOL) shouldAcceptAvgAviableSizeToEveryCustomView:(AUSegment *)segment;

/**
 *是否把默认空间分配给CustomView，而不是给Margin
 *shouldAcceptAvgAviableSizeToEveryCustomView 必须返回YES才有效
 *@return YES，表明多出来的空间分配给每一个Item，则调用acceptAvailibleSize:contentSize:的第一个参数是撑大的空间
 *@return NO ，表明多出来的空间分配给Margin，每一个Item大小不变。
 *
 */
-(BOOL) shouldDistributeAviableSpaceToCustomView:(AUSegment *)segment;

///**
// *
// *当有足够空间的时候，是否自动计算Margin
// *如果设置
// *默认返回NO
// *
// */
//-(BOOL) shouldAcceptAvgAviableSizeToEveryCustomView:(AUSegment *)segment;

/**
 * 是否要在CustomView上加TapGesture。
 * 如果加上，业务delegate能收到didSegmentValueChanged的回调，并且CustomVIew的selected属性也能收到回调。
 * 如果不加，业务在自己感知到点击的时候，请调用[AUSegment changeSelectedSegment:];通知Segment发生了变化，Segment才能回调上述事件。
 * @return 默认返回YES
 */
-(BOOL) addTapGestureOnCustomView:(AUSegment *)segment;

@end


// segment 默认高度
#define     AUSegmentHeight     AU_SPACE13

/**
    分段切换组件
    文档地址 https://yuque.antfin-inc.com/antui/auidoc/ios_ausegment
 */
@interface AUSegment : AUKView

@property (nonatomic,strong) AUSegmentStyle *style;

/**
 初始化函数

 @param frame  frame
 @param titles 数组：包含所有标题字符串

 @return 返回AUSegment实例
 */
- (instancetype)initWithFrame:(CGRect)frame titles:(NSArray<NSString*> *)titles;

- (instancetype)initWithFrame:(CGRect)frame enableNewFeature: (BOOL) enable;

- (CGRect) fetchSliderViewFrameFor: (NSInteger)segmentIndex;
/**
 禁用init方法
 */
- (instancetype)init NS_UNAVAILABLE;


@property (nonatomic,readonly) AUKCollectionView *collectionView;

/// 是否启用新特性
/// 包含字体会变大
/// 选中条可以滑动
@property (nonatomic, readonly) BOOL enableNewFeature;
/**
 AUSegmentedControlDelegate
 */
@property (nonatomic, weak) id <AUSegmentedControlDelegate> delegate;

@property (nonatomic, weak) id <AUSegmentedControlDataSource> dataSource;

/**
 当前选中的segment
 */
@property (nonatomic, assign) NSInteger selectedSegmentIndex;


/**
 * 是否自动滚动选中菜单项到合适位置（优先中间位置，不够位置时再靠边显示）
 * 默认为NO
 */
@property (nonatomic, assign) BOOL autoScroll;

/**
 * 是否隐藏底部的线
 **
 */
@property (nonatomic, assign) BOOL hideBottomLine;


/**
 * 是否隐藏选中条
 * 默认NO
 */
@property (nonatomic, assign) BOOL hideSelectedBar;


@property (nonatomic, strong) UIView *fixedRightView;
/*
 * model数组
 */
@property(nonatomic, strong) NSMutableArray<AUSegmentItemModel *> *itemModels;

/*
 * 隐藏左右两边的渐变阴影。
 *
 */
@property (nonatomic, assign) BOOL hideMaskView;



@end





@interface AUSegment (ItemModel)

/**
 * 第二版的初始化函数
 * @param frame  frame
 * @param menus  item 数组
 */
- (instancetype) initWithFrame:(CGRect)frame menus:(NSArray<AUSegmentItemModel *>*)menus;

- (instancetype) initWithFrame:(CGRect)frame menus:(NSArray<AUSegmentItemModel *>*)menus enableNewFeature: (BOOL) enable;
/**
 支持更新控件item项
 
 @param items 删除已有数据，重新替换为新的item数据
 */
- (void)updateItemModel:(AUSegmentItemModel *)model
                atIndex:(NSInteger)index;


- (void)updateItems:(NSArray<AUSegmentItemModel *>*)items;


@end

@interface AUSegment (CustomView)


- (instancetype)initWithFrame:(CGRect)frame;

- (void) changeSelectedSegment:(UIView *)selectedCustomView;

- (void) changeSelectedSegmentAtIndex:(NSInteger)newSegmentIndex;


- (void) reloadData;

- (NSArray<UIView*>*) visibleViews;

@end


@interface AUSegment (Legacy)

@property (nonatomic,strong) NSArray *titles;

/**
 * !!! 10.2.18 这个参数都是NO,设置YES没啥用。
 */
@property (nonatomic, assign) BOOL fixedItemWidth __attribute__((deprecated("10.2.18 这个参数都是NO,设置YES没啥用。")));

/*
 * 在初始化的时候设置，这个没用了。
 */
@property (nonatomic, strong) NSArray *itemModels __attribute__((deprecated("在初始化的时候设置，这个没用了。")));

/**
 *都通过Style属性来设置
 */
@property (nonatomic, strong) UIColor *titleColor __attribute__((deprecated("都通过Style对象来设置,segment.style.titleColor = ")));

@property (nonatomic, strong) UIFont *titleFont __attribute__((deprecated("都通过Style对象来设置,segment.style.titleFont = ")));;

@property (nonatomic, strong) UIColor *selecedColor __attribute__((deprecated("都通过Style对象来设置,segment.style.selectedColor = ")));

@property (nonatomic, strong) UIColor *selectedBarColor __attribute__((deprecated("都通过Style对象来设置,segment.style.selectedColor = ")));

@property (nonatomic, strong) NSNumber *unSelectedForegroundAlpha __attribute__((deprecated("都通过Style对象来设置,segment.style.unSelectedForegroundAlpha = ")));

@end
#endif//程序自动生成
