//
//  AUSafeDialog.h
//  字体demo
//
//  Created by 胡胡超 on 2022/8/29.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN
static NSInteger  kAUSafeDialogForceDismissIndex = 9999999;
static NSInteger  kAUSafeDialogCanceleIndex = -1;

@class AUSafeDialog;
@protocol AUSafeDialogDelegate <UIAlertViewDelegate>

@optional
/**
 点击按钮回调

 @param dialogView 点击的 dialog 视图
 @param buttonIndex 点击的按钮索引
 */
- (void)dialogView:(AUSafeDialog *)dialogView clickedButtonAtIndex:(NSInteger)buttonIndex;


- (void)dialogViewClickedLinkButton:(AUSafeDialog *)dialogView;


///**
// 即将消失回调
//
// @param dialogView dialog 视图
// @param buttonIndex 点击的按钮索引
// */
//- (void)dialogView:(AUSafeDialog *)dialogView willDismissWithButtonIndex:(NSInteger)buttonIndex;
//
///**
// 已经消失回调
//
// @param dialogView dialog 视图
// @param buttonIndex 点击的按钮索引
// */
//- (void)dialogView:(AUSafeDialog *)dialogView didDismissWithButtonIndex:(NSInteger)buttonIndex;


@end

@interface AUSafeDialog : UIView

@property (nonatomic, weak) id<AUSafeDialogDelegate>    delegate;
@property (nonatomic, assign) BOOL    backgroundMark;
@property (nonatomic, assign) NSTimeInterval animationDuration;
@property (nonatomic, assign) BOOL au_isWhiteListOnBackgroundMode;

@property (nonatomic, strong) UIView *alertContainer;
//@property (nonatomic, strong) UIScrollView *alertScrollView; // 内容超出屏幕范围支持滚动展示
@property (nonatomic, strong) UIView *contentView;
@property (nonatomic, strong) UIView *buttonView;
@property(nonatomic, assign)BOOL useDialogManager;//是否走弹窗管控，默认YES走弹窗管控

- (instancetype)initWithImageView:(nullable UIImageView *)imageView
                        title:(nullable NSString *)title
                      message:(nullable NSString *)message
                      detailText:(nullable NSString *)detailText
                     delegate:(nullable id<AUSafeDialogDelegate>)delegate
                     linkText:(nullable NSString *)linkText
               cancelButtonTitle:(nullable NSString*)cancelButtonTitle
                 buttonTitles:(nullable NSArray<NSString*> *)buttonTitles;

//在支付端内，不消费
- (void)showInWindow:(UIWindow*)window;

- (void)dismiss;
@end

NS_ASSUME_NONNULL_END
