#import <AntUI/AUUILoadDefine.h>
#ifdef ANTUI_UI_alert//程序自动生成
//
//  AUPopupManager.h
//  AntUI
//
//  Created by Wang on 2018/4/24.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

#pragma --mark Notification

extern NSNotificationName AUPopupManagementViewDidShowNotification;
extern NSString *AUpopupManagementNotificationKeyBindingClassName; // 绑定的Controller类名
extern NSString *AUpopupManagementNotificationKeyPriority; // 优先级
extern NSString *AUpopupManagementNotificationKeyPopupClassName; // 弹窗类名

#pragma --mark Notificaiton End

typedef NS_ENUM(NSUInteger,AUPopupType){
    AUPopupTypeBindController,
    AUPopupTypeGlobal //全局性的，任何界面都可以弹，比如吱口令
};

typedef NS_ENUM(NSInteger,AUPopupEvent) {
    AUPopupEventShow, //展示
    AUPopupEventDismiss, //消失
    AUPopupEventPause, //暂存，在亚后台以及Alert出现时进行，有机会会恢复
    AUPopupEventContinue, //恢复
    AUPopupEventPreShow, //预展示
    
    AUPopupEventUnableToShowView,//页面无法展示的
    
    AUPopupEventCheckViewStatus, //确定View的展示状态
};


typedef NS_ENUM(NSInteger,AUPopupEventReason) {
    AUPopupEventReasonViewDisappear, //展示
    AUPopupEventReasonOtherAppNotice, //消失
    AUPopupEventReasonQuitAll,
    AUPopupEventReasonQuitBelow,
    AUPopupEventReasonReplaced,
    AUPopupEventReasonUnableToShow
};

#define AUPopupEventReasonStr  @"AUPopupEventReason"


#define kAUPopupProtocolControllerKey  @"kAUPopupProtocolControllerKey"

#define kAUPopupProtocolShowCurrentControllerKey  @"kAUPopupProtocolShowCurrentControllerKey"

#define kAUPopupProtocolBackgroundModelKey @"kAUPopupProtocolBackgroundModelKey"

#define kAUPopupProtocolCompleteBlockKey  @"kAUPopupProtocolCompleteBlockKey"

typedef void (^AUPopupCompleteBlock)();

/**
 * 优先级排序（从高到低):
 * 业务
 * ShareToken
 * CDP
 */
typedef NS_ENUM(NSInteger,AUPopupPriority)
{
    AUPopupPriorityClose = -1,
    AUPopupPriorityUndefined = 0,
    AUPopupPriorityBiz = 100,//业务
    AUPopupPriorityShareToken = 60,
    AUPopupPriorityBetweenCDP_ShareToken =  55,//比CDP高，比ShareToken低
    AUPopupPriorityCDP = 50,
    AUPopupPriorityBelowCDP = 40
};

typedef NS_ENUM(NSInteger,AUPopupCanshowStatus)
{
    AUPopupCanshowStatusCan, //可以展示
    AUPopupCanshowStatusCant,//暂时不可以展示
    AUPopupCanshowStatusExpired,//永久不能展示了，可以销毁
};

@protocol AUPopupProtocol

@required

-(void) handlePopupEvent:(AUPopupEvent)event options:(NSDictionary*)options;


@optional

-(NSString *) bizId; //业务定义

-(AUPopupPriority) defaultPriorityForPopup; // 返回业务默认优先级

-(UIViewController *)linkedController;

-(AUPopupCanshowStatus) canShowOnCurrentContext:(id)context;

-(NSDictionary *) extInfo;

@end

//具体的实现类，如果没有该Key，则认为是view。
static NSString *AUPopupManagerLogImplementationKey = @"ImplementationKey";

@interface AUPopupManager : NSObject


+(instancetype) sharedInstant;

-(void) showOrQueue:(UIView<AUPopupProtocol> *)view type:(AUPopupType)type;

-(void) showOrQueue:(UIView<AUPopupProtocol> *)view type:(AUPopupType)type logParam:(NSDictionary *)logParam;

-(BOOL) showNextIfNeeded;

-(void) hidePopupView:(UIView<AUPopupProtocol> *)view;

-(void) hidePopupView:(UIView<AUPopupProtocol> *)view logParam:(NSDictionary *)logParam;

-(void) hidePopupView:(UIView<AUPopupProtocol> *)view logParam:(NSDictionary *)logParam complete:(void(^)())complete;

+(BOOL) isAUPopUpManagedEnable:(NSString*)bizId;

+(BOOL) isAUPopUpManagedEnable:(NSString*)bizId defaultPriority:(AUPopupPriority)prority;

-(void) dismissAllPopup;

-(void) queueAllPopup;

/**
 * 是否有弹窗在显示
 * 包含两种情况：
 * 1. topController有弹屏
 * 2. 关键业务正在运行（收银台）
 * 3. 有dialogWindow
 */
-(BOOL) hasWindowShowing;
/**
 * 是否有antui弹窗在显示
 * 包含两种情况：
 * 1. topController有弹屏
 * 2. 有dialogWindow
 */
-(BOOL) hasDialogShowing;

/**
 * dismissAll 降级开关是否回滚
 */
-(BOOL) hasDismissAllRollbacked;

//将优先级<=priority的都压栈
//并且后续低于priority的弹窗直接压栈，知道调用popUpWindowIfNeeded。
-(BOOL) queueAllPopupBelowPrioproty:(AUPopupPriority)priority;

-(void) recoveryPopup;
//-(void) popUpWindowIfNeeded;
//-(void) resumeAllPopup;

@end


@interface AUPopupManager (WhiteList)

@property(nonatomic,assign) BOOL isBackGroundMode;//是否是后台模式


// 设置白名单不受 BackGroundMode 的压制影响
- (void)addToWhiteList:(UIView *)dialog;

// 清空白名单
- (void)clearWhiteList;

// 检测弹窗实例是否在白名单列表内
- (BOOL)whiteListIsContainDialog:(UIView *)dialog;



@end


@interface UIView (AU_PopupManagementExtension)

@property (nonatomic,assign) AUPopupType au_popupType;

@property (nonatomic,assign) NSTimeInterval au_showTimeInterval;

@property (nonatomic,assign) NSUInteger au_dialogIndex;

@property (nonatomic,assign) BOOL au_isWhiteListOnBackgroundMode;

@end

NSDictionary *AUDictionaryCombine(NSDictionary *d1,NSDictionary *d2) ;

void AUPopLogEvent(NSString *action,NSObject *implementClass,NSDictionary *content);



#endif//程序自动生成
