//
//  AUPopMsgView.h
//  AntUI
//
//  Created by niki on 2018/11/21.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <AntUI/AUPopDrawBoardView.h>

NS_ASSUME_NONNULL_BEGIN

// 主副标题同时居左或者h同时居中
typedef NS_ENUM(NSInteger, AUPopMsgViewLabelAlignment) {
    AUPopMsgViewLabelAlignmentLeft = 1, // default
    AUPopMsgViewLabelAlignmentCenter = 2,
};


// 左边支持自定义icon + 右边支持
@interface AUPopMsgView : AUPopDrawBoardView

+ (instancetype)showFromView:(UIView *)fromView
                   fromPoint:(CGPoint)fromPoint
                      toView:(UIView *)toView
                    withIcon:(UIImage *)image
                       title:(NSString *)title
                    descText:(NSString *)descText;
//
- (void)dismiss;

//
- (void)setPopMsgViewLabelAlignment:(AUPopMsgViewLabelAlignment)alignment;

@end

@interface AUPopMsgView (AUPopViewSetup)

// maxWidth 一般取值为toView的width
- (instancetype)initWithMaxWidth:(CGFloat)maxWidth
                        withIcon:(UIImage *)icon
                           title:(NSString *)title
                        descText:(NSString *)descText;

// 设置浮层相对toView边缘的间距，默认贴边渲染（需要在show方法前设置才能生效）
- (void)setHorizontalMargin:(CGFloat)value;

- (void)showWithFromView:(UIView *)fromView
                 atPoint:(CGPoint)atPoint
                  toView:(UIView *)toView;

@end

NS_ASSUME_NONNULL_END
