//
//  AUNoticeBar.h
//  AntUI
//
//  Created by Wang on 2020/2/4.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@class AUImageViewModel;

/*
 Model 对应View布局
 
|-------------------------------------------------------|
|  mainImageModel  mainTitle      desc                  |
|  subTitle                       descImageModel        |
|-------------------------------------------------------|
 */
@interface AUNoticeBarViewModel : NSObject

@property (nonatomic,strong) AUImageViewModel *mainImageModel;

@property (nonatomic,strong) NSString *mainTitle;
@property (nonatomic,strong) NSString *desc;
@property (nonatomic,strong) NSString *subTitle;

@property (nonatomic,strong) AUImageViewModel *descImageModel;

@end

typedef NS_ENUM(NSUInteger,AUNoticeBarDismissType)
{
    AUNoticeBarDismissTypeInvoke,//调用Dismiss方法进行小时
    AUNoticeBarDismissTypeTimer,//定时器触发
    AUNoticeBarDismissTypeSwipeTop, //向上滑动
    AUNoticeBarDismissTypeClick, //点击
    AUNoticeBarDismissTypeDismissAll
};

@interface AUNoticeBar : UIWindow

@property (nonatomic,strong) AUNoticeBarViewModel *viewModel;

/**
 *  所有消失时的回调
 *
 */
@property (nonatomic,copy) void(^completeOnDismiss)(AUNoticeBar *,AUNoticeBarDismissType) ;


@property (nonatomic,copy) BOOL(^clickBlock)(AUNoticeBar *bar) ;
/**
 * 默认展示时间，<=0 一直展示
 * */
@property (nonatomic,assign) CGFloat showDuration;



-(void) show;

-(void) dismiss:(BOOL) animated complete:(void(^)())complete;

+(void) dismissAll;

@end

NS_ASSUME_NONNULL_END
