//
//  AUKeyBoardStateRecorder.h
//  AntUI
//
//  Created by Wang on 2021/5/21.
//  Copyright © 2021 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@protocol AUKeyBoardStateProtocol <NSObject>

-(void) auKeyboardStateSizeDidChanged:(CGSize) size;

@end


@interface AUKeyBoardStateRecorder : NSObject

@property (nonatomic,assign) BOOL isKeyboardShowing;

@property (nonatomic,assign) CGSize currentkeyboardSize;

-(void) start;

-(void) addKeyboardStateListener:(NSObject <AUKeyBoardStateProtocol>*)o;

@end


AUKeyBoardStateRecorder *AUKeyBoardStateRecorderGet();


NS_ASSUME_NONNULL_END
