//
//  AUImageLottieViewModel.h
//  AntUI
//
//  Created by 图灵 on 2022/10/19.
//  Copyright © 2022 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface AUImageLottieViewModel : NSObject

/// 图片的占位符
@property (nonatomic,strong) UIImage *placeHolder;

/// lottieView的兜底图，可以传入本地或远程地址，但需要符合文档https://yuque.antfin-inc.com/qxfzv9/gy2rr1/ihtw8g#NNWOX规定
@property (nonatomic, strong) NSString *lottieViewPlaceHolder;
/// lottie资源路径，是一个json文件
/// 如果是本地路径，请按以下规则拼写：file:///APCommonUI.bundle/lottieData.json
@property (nonatomic,strong) NSString *url;
/// lottie资源路径是否是远程的
@property (nonatomic, assign) BOOL isRemote;
/// 图片的大小
@property (nonatomic,assign) CGSize requiredSize;
/// lottie动画的播放次数
@property (nonatomic, assign) NSInteger repeatCount;

@property (nonatomic,strong) NSString *bizID;//多媒体申请到的业务标示，如果不传使用AntUI的。


- (instancetype)initWithPath: (nonnull NSString *)url
                    isRemote: (BOOL)isRemote
                 placeHolder: (nonnull UIImage *)placeHolder
       lottieViewPlaceHolder: (nonnull NSString *)lottieViewPlaceHolder
                       bizID: (nonnull NSString *)bizID;
@end

NS_ASSUME_NONNULL_END
