//
//  AUImageDialog+AULottieStyle.h
//  AntUI
//
//  Created by niki on 2019/1/14.
//  Copyright © 2019年 Alipay. All rights reserved.
//

#import <AntUI/AntUI.h>

NS_ASSUME_NONNULL_BEGIN

@interface AUImageDialog (AULottieStyle)

/**
 不带按钮标题的初始化方法。
 
 @param filePath Lottie资源
 @param placeholder lottie的展位图，占位图最好与Lottie视图同尺寸，否则视图可能错乱
 @param title 标题
 @param message 消息内容
 @param delegate 协议对象（遵循 AUDialogDelegate）
 @return AUImageDialog 实例
 */
- (instancetype)initWithLottieFilePath:(NSString *)filePath
                           placeHolder:(UIImage *)placeholder
                                 title:(NSString *)title
                               message:(NSString *)message
                              delegate:(id<AUDialogDelegate>)delegate;

/**
 不带按钮标题的初始化方法。
 
 @param filePath Lottie资源
 @param title 标题
 @param message 消息内容
 @param delegate 协议对象（遵循 AUDialogDelegate）
 @return AUImageDialog 实例
 */
- (instancetype)initWithLottieFilePath:(NSString *)filePath
                                 title:(NSString *)title
                               message:(NSString *)message
                              delegate:(id<AUDialogDelegate>)delegate;

@end

NS_ASSUME_NONNULL_END
