#import <AntUI/AUUILoadDefine.h>
#import "AUImageLottieViewModel.h"
#ifdef ANTUI_UI_BaseComponent_AUImageView//程序自动生成
//
//  AUImageView.h
//  AntUI
//
//  Created by maizhelun on 2016/9/26.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>


AntUI_BaseComponent

@class AUImageViewModel;

//AUIImageView 是系统类，避免审核冲突问题

@class AUImageViewModel;
@class AUIImageView;

typedef NS_ENUM(NSUInteger,AUIImageViewSetType) {
    AUIImageViewSetTypeNone = 0,//没有图片
    AUIImageViewSettypePlaceHolder, //placeHolder
    AUIImageViewSettypeURLInCache, //已经下载好的图片
    AUIImageViewSettypeURL//图片下载
};

@protocol AUIImageViewProtocol <NSObject>

-(void) imageview:(AUIImageView *)imageView didSetImage:(UIImage*)image forImageSetType:(AUIImageViewSetType)type;

@end

@interface AUIImageView : UIImageView

@property (nonatomic,strong) AUImageViewModel *viewModel;
@property (nonatomic,weak) id<AUIImageViewProtocol> delegate;
/// lottie View的一些配置模型数据
/// - Note：此属性仅仅在通过
/// (instancetype)initWithAUImageLottieViewModel: (AUImageLottieViewModel *)model
/// lottieLoadcompletion:(void(^)(AUIImageView *imageView, NSError *error))completion
/// 方法初始化时才会被赋值
///
/// 为何设置此属性，因为在AV2PopContentView中的updateConstraints方法中，根据viewModel中的大小设置了AUImageView的约束，而不会考虑AUImageView是不是挂载了一个LottieView
/// 此过程之前没有触发bug的原因是AUV2PopTipView不支持Lottie动画，因此不会出现通过Lottie初始化方法初始化时 AUImageView的大小永远为默认大小的情况
/// 在新需求中，AUV2PopTipView需要支持Lottie动画，为了代码更小的改动，需要在AV2PopContentView中的updateConstraints方法中增加一个判断AUImageView是否是通过Lottie初始化方法生成的，如果是那么需要根据生成时的AUImageLottieViewModel设置好AUImageView的大小
@property (nonatomic, strong) AUImageLottieViewModel *lottieViewModel;
@end



@interface AUIImageView (AULottie)

// 返回image的大小（如果是lottie，返回的是lottie的view的大小）
@property (nonatomic, readonly) CGSize imageSize;


/**
 用lottie初始化imageview（异步加载lottie）
 
 @param lottiePath lottie的文件路径
 @param placeholder lottie初始化失败时的占位图（极低概率）
 @return AUImageView实例
 */
- (instancetype)initWithLottiePath:(NSString *)lottiePath
                       placeholder:(UIImage *)placeholder
              lottieLoadcompletion:(void(^)(AUIImageView *imageView, NSError *error))completion;

/**
 用lottie初始化imageview（异步加载lottie）

 @param model 加载资源的数据模型
 @param completion 加载完成的回调
 @return AUImageView实例
 */
- (instancetype)initWithAUImageLottieViewModel: (AUImageLottieViewModel *)model
                          lottieLoadcompletion:(void(^)(NSError *error))completion;

/**
 用lottie初始化imageview（同步加载lottie）

 @param lottiePath lottie的文件路径
 @return AUImageView实例
 */
- (instancetype)initWithLottiePath:(NSString *)lottiePath;


/**
 播放lottie动画
 */
- (void)startAnimating;


- (void)lottie_pauseAnimating;

/**
 停止lottie动画
 */
- (void)stopAnimating;

@end

@interface AUImageViewModel : NSObject

@property (nonatomic,strong) UIImage *placeHolder;
@property (nonatomic,strong) NSString *url;
@property (nonatomic,assign) CGSize requiredSize;
@property (nonatomic,strong) NSString *busniness;//多媒体申请到的业务标示，如果不传使用AntUI的。

@end

/**
 *
 */
AUImageViewModel *AUImageViewModelIconfontMake(NSString *iconfontName,UIColor *foreColor,CGSize size);

#endif//程序自动生成
