//
//  AUFloatView.h
//  AntUI
//
//  Created by Wang on 2021/5/20.
//  Copyright © 2021 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger,AUFloatViewEvent)
{
    AUFloatViewEventBeginDrag ,//开始拖拽
    AUFloatViewEventDragEnd ,//松手
    AUFloatViewEventWillAdhere,//开始吸附
    AUFloatViewEventDidAdhere,//吸附结束
    AUFloatViewEventClick//点击悬浮球
    
};

@class AUFloatViewContext;
/**
 * 悬浮球基类，业务继承该类实现自己的View样式
 */
@interface AUFloatView : UIControl

@property (nonatomic,copy) AUFloatViewContext *context;

//是否是展开态
@property (nonatomic,assign,readonly) BOOL isExpand;

//吸附时离4边的Margin
@property (nonatomic,assign) UIEdgeInsets adHesionInsets;

//当前位置。
@property (nonatomic,assign,readonly) CGPoint currentPostion;

//浮窗的SuperView
//如果是独立WIndow形式，返回Nil
@property (nonatomic,assign,readonly) UIView *contextSuperView;


-(id) initWithFrame:(CGRect)frame __attribute((objc_requires_super));

/**
 * 展示悬浮球
 */
-(AUFloatViewContext *) showAtPosition:(CGPoint) point __attribute((objc_requires_super));


/**
 * 隐藏并销毁悬浮球
 */
-(AUFloatViewContext *) dismiss __attribute((objc_requires_super));


/**
 *
 * 在收起状态下（isExpand == NO）点击自身会回调改方法。
 * 如果业务悬浮球又展开/收起逻辑，在这个方法里实现自定义展开逻辑，点击悬浮球会回调这个方法。
 */
-(void) expand:(AUFloatViewContext*)context __attribute((objc_requires_super));

/**
 * 在展开状态（isExpand == YES）下再点击会回调该方法。
 */
-(void) shrink:(AUFloatViewContext*)context __attribute((objc_requires_super));



-(void) handleEvent:(AUFloatViewEvent) event context:(AUFloatViewContext*)context userInfo:(NSDictionary *_Nullable)userInfo;



@end


typedef NS_ENUM(NSInteger,AUFloatViewContextTriggerBy)
{
    AUFloatViewContextTriggerByUser,//用户触发
    AUFloatViewContextTriggerByManager,//管控触发
    AUFloatViewContextTriggerByUserDismiss, //用户出发Dismiss
};

typedef NS_ENUM(NSInteger,AUFloatViewContextShowType)
{
    AUFloatViewContextShowTypeNaviViewSubview,//作为NavigationController.view的subview
    AUFloatViewContextShowTypeWindow,//Window形式展示
    AUFloatViewContextShowTypeMainWindowSubview //作为主Window的SubView
};

typedef NS_ENUM(NSInteger,AUFloatViewAdhesionType)
{
    AUFloatViewAdhesionTypeStay,//不吸附
    AUFloatViewAdhesionTypeJustified,//两侧吸附
};

@interface AUFloatViewContext : NSObject<NSCopying>

@property (nonatomic,assign) AUFloatViewContextTriggerBy triggerBy;

@property (nonatomic,assign) AUFloatViewContextShowType showType;

@property (nonatomic,assign) AUFloatViewAdhesionType adhesionType;

/*
 * 是否被管控了。
 * 在管控状态下有可能返回YES。但只表明当前是否成功执行，管控pipeLine执行到还是会展示的。
 * 一期这个值都是NO。
 */
@property (nonatomic,assign,readonly) BOOL isManagedSuspend;


@end

NS_ASSUME_NONNULL_END
