#import <AntUI/AUUILoadDefine.h>
//
//  AUFeedbackMenu.h
//  AntUI
//
//  Created by zibai on 2021/9/7.
//  Copyright © 2021 Alipay. All rights reserved.
//

#import <AntUI/AUFeedbackCellDataModel.h>
#import <AntUI/AUPopTipView.h>

@class AUFeedbackCellView;

/**内部会取统一设置比例进行放大，不用业务au_scalingModel。
 *  @class       AUCardMenu
 *  @abstract    AUPopTipView
 *  @discussion  负反馈菜单
 */
@interface AUFeedbackMenu : AUPopTipView<AUUEPModelSupport>
{
}

/**
 *  若需要响应点击事件，需要对 cellView 实现 AUFeedbackCellDelegate 协议
 *  在自己的 viewcontroller 中赋值 popMenuView.cellView.delegate = self;
 */
@property (nonatomic, strong) AUFeedbackCellView *cellView;

/**
 *  初始化方法
 *  @param datas     数组存放对象模型 FeedbackCellDataModel
 *  @return self
 */

- (instancetype)initWithDatas:(NSArray<AUFeedbackCellDataModel *> *)datas;

/**
 *  展示负反馈菜单
 */
- (void)showPopMenu:(UIView *)superView
         atPosition:(CGPoint)location;

/**
 *  展示负反馈菜单；坐标 x 值取 origin.x + size.width / 2，坐标 y 值根据展示方向不同自动使用 origin.y 或 origin.y + size.height
 */
- (void)showPopMenu:(UIView *)superView
          withFrame:(CGRect)frame;

/**
 *  隐藏负反馈菜单，最好在 dealloc 方法里也调用
 */
- (void)hidePopMenu;

@end
