//
//  AUCircleProgressView.h
//  AntUI
//
//  Created by Wang on 2020/6/1.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@interface AUCircleProgressView : UIView

@property (nonatomic, assign) BOOL    hidesWhenStopped;    //是否停止的时候隐藏掉
@property (nonatomic, strong) UIColor *trackColor;         //圆环颜色
@property (nonatomic, strong) UIColor *progressColor;      //指示器颜色
@property (nonatomic, assign) float progressWidth;         //设置圆环的宽度，自定义圆圈大小时，默认为2
@property (nonatomic, assign) CGFloat progress;            //加载指示器的弧长与圆环的比值，默认为0.1



/**
 开始执行动画
 */
- (void)startAnimating;

/**
 停止执行动画
 */
- (void)stopAnimating;

/**
 是否正在执行动画

 @return YES，动画执行中；NO，没有执行动画
 */
- (BOOL)isAnimating;


@end

NS_ASSUME_NONNULL_END
