#import <AntUI/AUUILoadDefine.h>
#ifdef ANTUI_UI_BaseComponent_AUButton//程序自动生成
//
//  AUButton.h
//  AntUI
//
//  Created by maizhelun on 2016/9/15.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>


//#########################################################
//文档地址 : https://yuque.antfin-inc.com/antui/auidoc/ios_aubutton
//#########################################################

typedef void (^AUButtonBlock)();

/**
 * AUButtonStyle 为样式集合
 * 说明: 【】为当AUButtonType为AUButtonTypeOldStyle时的默认展示默认的展示形式，可以通过构造方法中指定修改
 *
 *
 */
typedef NS_ENUM(NSInteger, AUButtonStyle) {
    AUButtonStyleNone,  //系统默认
    AUButtonStyle1,     //蓝底，白字，无边框，【旧：大按钮样式】
    AUButtonStyle2,     //白底，黑字，浅灰色边框，【旧：大按钮样式】
    AUButtonStyle3,     //透明底，蓝字，蓝色边框，【旧：小按钮字样】
    AUButtonStyle4,     // 白底，默认带上下分割线，字是红色的；使用场景（取消关注）等页面底部操作，默认高度--使用方法来查询，宽度为屏幕宽度
    AUButtonStyle5,     // 白底，默认带上下分割线，字是蚂蚁蓝；使用场景（更多服务）等页面底部操作，默认高度--使用方法来查询，宽度为屏幕宽度
    AUButtonStyle6,     // 红底白字，警告类操作，【旧：大按钮样式】
    AUButtonStyle7,     // 白底，黑字，浅灰色边框，【旧：小按钮样式】
    AUButtonStyle8,     // 蓝底，白字，无边框，【旧：小按钮样式】
    AUButtonStyle9,     // 白底，字是红色的；使用场景登出，【旧：大按钮样式】
    AUButtonStyleCustomlize, //自定义
    AUButtonStyle10,    // 淡蓝色背景，蓝色字体
    AUButtonStyleForTally,
    AUButtonStyleCustomlizeStyle, //自定义颜色部分
};

typedef NS_ENUM(NSInteger, AUButtonType) {
    AUButtonTypeOldStyle  = 0 ,//旧的样式，需要映射成新样式
    AUButtonTypeDefault   = 1, //主按钮，定宽，为【大按钮样式】
    AUButtonTypeMini      = 2, //小按钮,为【小按钮样式】
    AUButtonTypeCell      = 3, //TableViewCell，带上线边线
    AUButtonTypeDouble    = 4, //上下两行，主副标题,暂未实现
    AUButtonTypeCapsuleS  = 5, //胶囊按钮,对应字号24px，实际宽度
    AUButtonTypeCapsuleM  = 6, //胶囊按钮,对应字号26px，实际宽度
    AUButtonTypeCapsuleL  = 7, //胶囊按钮,对应字号30px，实际宽度
    AUButtonTypeCapsuleS_MinWidth  = 8, //胶囊按钮,AUButtonTypeCapsuleS,带最小宽度
    AUButtonTypeCapsuleM_MinWidth  = 9, //胶囊按钮,AUButtonTypeCapsuleM,带最小宽度
    AUButtonTypeCapsuleL_MinWidth  = 10, //胶囊按钮,AUButtonTypeCapsuleL,带最小宽度
};


typedef NS_ENUM(NSInteger, AUButtonHighlightedStyle) {
    AUButtonHighLightedStyleCommon,//普通按钮
    AUButtonHighLightedStyleList//列表按钮
};


#import <AntUIKit/AUKButton.h>
AntUI_BaseComponent
@protocol AUScreenScaleSupport;
@protocol AUScalingModelSupport;
@interface AUButton : AUKButton<AUScreenScaleSupport,AUScalingModelSupport>


@property (nonatomic,strong) UIColor *defaultBackgroundColor;
@property (nonatomic,strong) UIColor *defaultForegroundColor;
@property (nonatomic,strong) UIColor *defaultBorderColor;

/**
 * 是否是文字链，高亮/禁用状态只改变文本，不改变底背景
 */
@property (nonatomic, assign) BOOL isLinkType;

/**
 * 按钮样式
 */
@property (nonatomic, assign) AUButtonStyle style;

/**
 * 按钮类型
 */
@property (nonatomic, assign,readonly) AUButtonType type;


// button 行动block
@property (nonatomic, copy) AUButtonBlock actionblock;

@property (nonatomic, assign,readonly) AUButtonHighlightedStyle highlightedStyle;


-(id) initWithButtonStyle:(AUButtonStyle)style type:(AUButtonType)type;


-(void) setStyle:(AUButtonStyle)style hightlightedStyle:(AUButtonHighlightedStyle) highlightedStyle;

/**
 初始化方法

 @param style 样式

 @return 创建的初始化对象
 */
+ (instancetype)buttonWithStyle:(AUButtonStyle)style;


/**
 * 初始化方法
 * @param style 样式
 * @param type 类型
 * @return 创建的初始化对象
 */
+ (instancetype)buttonWithStyle:(AUButtonStyle)style type:(AUButtonType)type;



/**
 *  初始化的辅助方法，用于创建并初始化一个按钮的对象。
 *
 *  @param style      按钮类型，必须是定义在<code>AUButtonStyle</code>中的其中一个值。
 *  @param title      铵钮标题
 *  @param target     响应按钮点击事件的对象
 *  @param action     响应按钮点击事件的函数
 *
 *  @return 新创建并经过初始化的按钮对象。
 *  
 *  此方法初始化的对象 需要设置frame
 */
+ (instancetype)buttonWithStyle:(AUButtonStyle)style title:(NSString *)title target:(id)target action:(SEL)action;

/*
 *  获取默认样式 button 的高度，旧方法
 */
+ (CGFloat)buttonHeightWithStyle:(AUButtonStyle)style;

/**
 获取默认样式 button 的高度，新方法
 */
+ (CGFloat)buttonHeightWithType:(AUButtonType)type;

/**
 * 屏幕适配推荐这种方式
 * Example:
        AUButton *button = [[AUButton alloc]initWithType:AUButtonTypeCapsuleS];
        _button.au_screenScaleSupport = self.au_screenScaleSupport;
        [_button setStyle:AUButtonStyle2 hightlightedStyle:AUButtonHighLightedStyleCommon];
        [_button setTitle:XXXX forStatus:XXXX]
        [_button sizeToFit];
 */
-(id) initWithType:(AUButtonType)type;


@end

@interface AUButton(APButtonExt)

+ (AUButton *)buttonWithType:(AUButtonStyle)buttonType title:(NSString *)title target:(id)target action:(SEL)action;

- (id)initWithButtonType:(AUButtonStyle)buttonType;

@end



/**
 * 根据Color计算出高亮时的颜色
 */
UIColor * AUButtonGetHighlightedBackColor(UIColor *color);

UIColor * AUButtonGetHighlightedForeColor(UIColor *color);

/**
 * 列表按钮计算规则
 */
UIColor * AUListButtonGetHighlightedBackColor(UIColor *color);


UIColor * AUListButtonGetHighlightedForeColor(UIColor *color);

/**
 * 根据Color计算出禁用时的颜色
 */
UIColor * AUButtonGetDisableColor(UIColor *color);


@interface AUButton (AULoading)

/**
 在按钮上展示菊花动画和文字，左菊花右文字，无文字时菊花居中
 
 @param loadingTitle 展示菊花时候的文字，设置nil或者空串不展示，菊花居中
 @param currentVC    当前VC，为了loading结束的去掉遮罩
 */
- (void)startLoadingWithTitle:(NSString *)loadingTitle currentViewController:(UIViewController *)currentVC;


/**
 停止转菊花
 */
- (void)stopLoading;

@end

//标题左侧的image
//since 10.1.38
@interface AUButton (LeftImageSupport)

-(void) setLeftTitleImage:(UIImage *)image;

@end



#endif//程序自动生成
