//
//  AUAntRefreshLottieView.h
//  AntUI
//
//  Created by niki on 2019/2/27.
//  Copyright © 2019年 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

#define     AURefreshMaxProgress            0.7624
#define     AURefreshStartOffset             20

typedef NS_ENUM(NSUInteger, AURefreshViewType) {
    AURefreshViewDefault = 0,       // 页面内的刷新样式,RGB(0x999999);
    AURefreshViewTypeFeature1 = 1 ,  // 用在带有一定背景的titlebar 如首页或者财富tab,白色样式,RGB_A(0xFFFFFF,0.6);
    AURefreshViewTypeImage = 1 << 1 ,  // 带图片的。
    AURefreshViewTypeFeature2 = 1 << 2, //灰色样式,RGB_A(0xCCCCCC,0.6);
};

extern CGSize AUAntRefreshLottieViewCustomViewSize();

// 蚂蚁下拉刷新专用lottie

@interface AUAntRefreshLottieView : UIView

// 定制化下拉刷新尺寸
@property (nonatomic, assign) CGSize customSize;

/*
 * @param type 小蚂蚁的状态
 * @param placeholderView 小蚂蚁的展位图，主要用于lottie加载异常时来展示
 */
- (instancetype)initWithLottieType:(AURefreshViewType)type;

- (instancetype)initWithFrame:(CGRect)frame lottieType:(AURefreshViewType)type;

- (instancetype)initWithFrame:(CGRect)frame
                   lottieType:(AURefreshViewType)type
                      bizType:(NSString *)bizType;


@property (nonatomic,strong) UIImage *titleImage;

@property (nonatomic,strong) UIView *customView;

@property (nonatomic,strong) UIImageView *labelImageView;


// 下拉刷新文案
- (void)setupLabelText:(NSString *)text;

// 下拉字体颜色
// 如果设置为空，则还原字体颜色
- (void)setupLabelForeColor:(nullable UIColor *)color;

//
typedef void (^AnimateCompletionBlock)(BOOL animationFinished);

/**
 *
 *切换下拉刷新样式。
 *只有收上去之后才会切换，确保动画进度正常。
 */
- (void)changeType:(AURefreshViewType)type;

/**
 * 动态修改Type的方法
 * 为小程序提供
 * @param newType 新的Type类型
 * @param complete 切换完成的回调
 * 如果要目标type和目前type一致，complete不会调用
 */
- (void)changeType:(AURefreshViewType)type completion:(nullable void (^)())completion;


// lottie视图动画的总帧数
- (NSNumber *)totalFrame;

// lottie视图动画当前在第几帧
- (NSNumber *)currentFrame;

// 设置当前帧数
- (void)setProgressWithFrame:(NSNumber *)frame;

// 设置是否循环
- (void)setLoopAnimation:(BOOL)loop; // 还存在

// 是否循环
- (BOOL)isLoopAnimation;

// 是否正在动画
- (BOOL)isAnimating;

//
- (void)pause;

//
- (void)play;

//
- (BOOL)isLottieViewLoadSuccess;

//
- (void)playCloseAnimation:(void (^)(BOOL animationFinished))completion;

//
- (void)startLoopAnimation:(void (^)(BOOL animationFinished))completion;

//
- (void)startTransitionalAnimation:(void (^)(BOOL animationFinished))completion;

//
- (CGFloat)getAnimationFrameWithOffset:(CGFloat)offset;

//
- (void)stopAnimating;


@end

// 以下是对外的接口
@interface AUAntRefreshLottieView (AURefreshPublic)

// 下拉未松手时根据scrollview的偏移量来决定蚂蚁所在帧数
- (void)setAntProgressWithScrollViewOffset:(CGFloat)offset;

// 前后台或切页面回来通过以下接口来重启动画
- (void)resumeAnimation;

// 松手时刻播放动画
- (void)endDraggingAndPlayAnimation:(void (^)(BOOL animationFinished))completion;

// 停止动画，等动画结束再收起scrollview
- (void)stopAnimating:(void (^)(BOOL animationFinished))completion;

@end



NS_ASSUME_NONNULL_END
