//
//  NSObject+AUTokenUpdater.h
//  111
//
//  Created by 胡胡超 on 2022/4/24.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
NS_ASSUME_NONNULL_BEGIN

@interface UIView (AUTokenUpdater)
//view的模式
@property (nonatomic,assign,readonly) BOOL aut_isDarkMode;
///内部调用au_bindTokenUpdater:updaterKey:
///updaterKey:[NSString stringWithFormat:@"self_%p",self]
-(void)au_bindTokenUpdater:(void(^)(BOOL isDark,UIView* SELF))updater;
-(void)au_unbindTokenUpdater;

///绑定一个更新block。将block通过key-vlaue形式存储到对象的字典中。当主题改变的时候，调用字典中的block
///注意：self会强是持有block 。引用关系( self->字典->block)
/// @param updater 1.调用au_bindTokenUpdater:updaterKey: 时，会立刻执行一次block。
///                2.主题切换调用的block
/// @param updaterKey 存储的key
-(void)au_bindTokenUpdater:(void(^)(BOOL isDark,UIView* SELF))updater updaterKey:(NSString *)updaterKey;
//解绑
-(void)au_unbindTokenUpdater:(NSString *)updaterKey;

///快速绑定一个更新block
@property (nonatomic,copy)UIColor* au_layerBorderColor;
@property (nonatomic,copy)UIColor* au_layerShadowColor;

@end

NS_ASSUME_NONNULL_END
